/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.plugins.io.IOTools;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractResourceMapper<T extends CommonResource> {
    public static final String TENANT_MODULE_NAME = "tenants";
    public static final String DEFAULT_CLOUD_DATA_PATH_VALUE = "cloudData";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceMapper.class);
    private static final boolean IS_JUNIT_TEST;
    private static final Map<ResourceType, Cache<String, String>> RES_CACHE;
    public static ThreadLocal<Boolean> RESOURCE_CHECK_FLAG;
    protected final LiuLiConfigService liuLiConfigService;
    protected final ApplicationUtils applicationUtils;
    private final ModuleMapper moduleMapper;
    protected Map<String, T> map;

    protected AbstractResourceMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        this.moduleMapper = moduleMapper;
        this.applicationUtils = applicationUtils;
        this.liuLiConfigService = liuLiConfigService;
    }

    private static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    public abstract ResourceType getResType();

    public abstract String getFileName();

    public abstract String getFolderName();

    @PostConstruct
    protected void loadMap() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, T>(36);
            this.putMapByRoot();
            this.moduleMapper.getMap().forEach((key, value) -> {
                String path = (String)value.get("path");
                try {
                    this.putMapByModule((String)key, path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            RES_CACHE.put(this.getResType(), (Cache<String, String>)CacheUtil.newLRUCache((int)100));
        }
    }

    private void putMapByRoot() {
        this.putMapByModule(null, null);
    }

    private void putMapByModule(String name, String parent) {
        String fileName = this.getFileName();
        ResourceType resType = this.getResType();
        Object str = parent == null ? (name == null ? fileName : name + "/" + fileName) : parent + "/" + name + "/" + fileName;
        IOTools.getStream((String)str, stream -> {
            Document document;
            SAXReader reader = new SAXReader();
            try {
                document = reader.read(stream);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            Element root = document.getRootElement();
            Iterator item = root.elementIterator(resType.getValue());
            while (item.hasNext()) {
                Element element = (Element)item.next();
                this.addRes(element, name, parent);
            }
        });
    }

    public final Map<String, T> getAllMap() {
        return this.map;
    }

    public final T getResource(String key, Boolean isThrowExceptionOnResourceNotFound) {
        String[] candidateAlias = this.getCandidateAliasList(key);
        String tenantName = this.applicationUtils.getTenantName();
        boolean isTenant = !tenantName.equals("standard") && !tenantName.equals("standard_test");
        for (String alias : candidateAlias) {
            String aliasItem;
            if (isTenant && this.map.containsKey(aliasItem = alias + "@" + tenantName)) {
                return (T)((CommonResource)this.map.get(aliasItem));
            }
            T res = this.buildResourceByLiuli(alias);
            if (res != null) {
                return res;
            }
            if (!this.map.containsKey(alias)) continue;
            return (T)((CommonResource)this.map.get(alias));
        }
        if (isThrowExceptionOnResourceNotFound.booleanValue()) {
            throw new ServiceException(this.getResType() + "\u8d44\u6e90[" + key + "]\u672a\u627e\u5230", Integer.valueOf(400));
        }
        return null;
    }

    private T buildResourceByLiuli(String alias) {
        if (RESOURCE_CHECK_FLAG.get() != null) {
            return null;
        }
        JSONObject liuliContent = this.liuLiConfigService.get(alias);
        if (liuliContent != null) {
            JSONObject globalProp = liuliContent.getJSONObject("$globalProp");
            return this.buildResource(globalProp.optString("module", null), alias, DEFAULT_CLOUD_DATA_PATH_VALUE, liuliContent, liuliContent.toMap());
        }
        return null;
    }

    public final T getResource(String key) {
        return this.getResource(key, true);
    }

    public final boolean hasResource(String key) {
        return Optional.ofNullable(this.getResource(key, false)).isPresent();
    }

    protected String[] getCandidateAliasList(String key) {
        return new String[]{key};
    }

    private String getResRealKey(Element element, String moduleName, String parentModuleName) {
        if (moduleName == null) {
            moduleName = "";
        }
        Object key = element.attribute("alias").getValue();
        if (IS_JUNIT_TEST && moduleName.startsWith("test_")) {
            key = "test_" + (String)key;
        }
        if (Objects.equals(parentModuleName, TENANT_MODULE_NAME)) {
            key = (String)key + "@" + moduleName;
        }
        return key;
    }

    private void addRes(Element element, String moduleName, String parentModuleName) {
        String key = this.getResRealKey(element, moduleName, parentModuleName);
        Object resPath = this.getResPath(element, moduleName, parentModuleName);
        if (resPath != null) {
            Map<String, Object> attrMap = element.attributes().stream().collect(Collectors.toMap(Node::getName, Attribute::getValue));
            this.map.put(key, this.buildResource(moduleName, key, resPath, null, attrMap));
        }
    }

    private String getValueByResource(CommonResource resource) {
        boolean isProd;
        if (this.isBinaryResource()) {
            throw new ServiceException("\u4e8c\u8fdb\u5236\u8d44\u6e90\u7c7b\u578b[" + this.getResType() + "]\u4e0d\u652f\u6301\u83b7\u53d6\u8d44\u6e90\u5185\u5bb9");
        }
        String source = null;
        String filePath = resource.getPath().toString();
        if (filePath.equals(DEFAULT_CLOUD_DATA_PATH_VALUE)) {
            return resource.getLiuLiValue().getString("source");
        }
        EnvType envType = this.applicationUtils.getEnvType();
        boolean bl = isProd = envType == EnvType.PROD;
        if (isProd) {
            source = this.getCache(resource);
        }
        if (source == null) {
            source = IOTools.readText((String)filePath);
            source = source.replace("\r\n", "\n");
            source = this.rewriteSource(source);
            if (isProd) {
                this.putCache(resource, source);
            }
        }
        return source;
    }

    protected Object getResPath(Element element, String moduleName, String parentModuleName) {
        Attribute pathAttribute = element.attribute("path");
        String path = pathAttribute.getValue();
        String folderName = this.getFolderName();
        return (parentModuleName == null ? moduleName + "/" + folderName + "/" : parentModuleName + "/" + moduleName + "/" + folderName + "/") + path;
    }

    private T buildResource(String moduleName, String key, Object path, JSONObject liuliValue, Map<String, Object> attrMap) {
        T resource = this.buildResourceImpl(moduleName, key, path, liuliValue, attrMap);
        if (!path.equals(DEFAULT_CLOUD_DATA_PATH_VALUE) && this.map.containsKey(key)) {
            CommonResource t = (CommonResource)this.map.get(key);
            ResourceType resType = this.getResType();
            throw new ServiceException(resType + "\u8d44\u6e90[" + key + "]\u91cd\u590d\u6ce8\u518c\uff1a\u5df2\u5b58\u5728\u8d44\u6e90\uff1a\u6a21\u5757[" + t.getModuleName() + "],\u8def\u5f84[" + t.getPath() + "];\u5f85\u6ce8\u518c\u8d44\u6e90\uff1a\u6a21\u5757[" + ((CommonResource)resource).getModuleName() + "],\u8def\u5f84[" + ((CommonResource)resource).getPath() + "];", Integer.valueOf(506));
        }
        return resource;
    }

    protected abstract T buildResourceImpl(String var1, String var2, Object var3, JSONObject var4, Map<String, Object> var5);

    protected String rewriteSource(String source) {
        if (this.isBinaryResource()) {
            throw new ServiceException("\u4e8c\u8fdb\u5236\u8d44\u6e90\u7c7b\u578b[" + this.getResType() + "]\u4e0d\u652f\u6301\u91cd\u5199\u6e90");
        }
        return source;
    }

    public void clearCache() {
        if (this.isBinaryResource()) {
            throw new ServiceException("\u4e8c\u8fdb\u5236\u8d44\u6e90\u7c7b\u578b[" + this.getResType() + "]\u4e0d\u652f\u6301\u6e05\u7a7a\u7f13\u5b58");
        }
        RES_CACHE.get((Object)this.getResType()).clear();
    }

    private void putCache(T resource, String source) {
        if (this.isBinaryResource()) {
            throw new ServiceException("\u4e8c\u8fdb\u5236\u8d44\u6e90\u7c7b\u578b[" + this.getResType() + "]\u4e0d\u652f\u6301\u66f4\u65b0\u7f13\u5b58");
        }
        RES_CACHE.get((Object)this.getResType()).put((Object)((CommonResource)resource).getAlias(), (Object)source);
    }

    private String getCache(T resource) {
        if (this.isBinaryResource()) {
            throw new ServiceException("\u4e8c\u8fdb\u5236\u8d44\u6e90\u7c7b\u578b[" + this.getResType() + "]\u4e0d\u652f\u6301\u83b7\u53d6\u7f13\u5b58");
        }
        return (String)RES_CACHE.get((Object)this.getResType()).get((Object)((CommonResource)resource).getAlias());
    }

    protected boolean isBinaryResource() {
        return false;
    }

    public boolean isSupportCompile() {
        return true;
    }

    static {
        RESOURCE_CHECK_FLAG = new ThreadLocal();
        IS_JUNIT_TEST = AbstractResourceMapper.isJUnitTest();
        RES_CACHE = new HashMap<ResourceType, Cache<String, String>>();
    }

    public static class CommonResource {
        private final AbstractResourceMapper<?> mapper;
        private final String moduleName;
        private final String alias;
        private final Object path;
        private final JSONObject liuLiValue;

        CommonResource(AbstractResourceMapper<? extends CommonResource> mapper, String moduleName, String alias, Object path, JSONObject liuLiValue) {
            this.mapper = mapper;
            this.moduleName = moduleName;
            this.alias = alias;
            this.path = path;
            this.liuLiValue = liuLiValue;
        }

        public String getAlias() {
            return this.alias;
        }

        public Object getPath() {
            return this.path;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public JSONObject getLiuLiValue() {
            return this.liuLiValue;
        }

        public JSONObject getJsonParams() {
            return new JSONObject().put("alias", (Object)this.getAlias()).put("path", this.getPath()).put("moduleName", (Object)this.getModuleName()).put("resType", (Object)this.mapper.getResType().getValue());
        }

        public String getSource() {
            return this.mapper.getValueByResource(this);
        }
    }

    public static interface MobileResourceSupport {
        public boolean isMobile();
    }

    public static interface DataSourceResourceSupport {
        public String getDataSource();
    }
}

