/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class LogicMapper
extends AbstractResourceMapper<LogicResource> {
    private static final Boolean DEFAULT_CACHE_STATE = false;
    private static final Long DEFAULT_CACHE_TIME = 60L;
    private static final Boolean DEFAULT_AUTH_STATE = true;
    private static final Boolean DEFAULT_MOBILE_STATE = false;
    private static final Boolean DEFAULT_CALLBACK_API_STATE = false;

    protected LogicMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        super(moduleMapper, applicationUtils, liuLiConfigService);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.LOGIC;
    }

    @Override
    public String getFileName() {
        return "logic.xml";
    }

    @Override
    public String getFolderName() {
        return "logics";
    }

    @Override
    protected LogicResource buildResourceImpl(String moduleName, String key, Object value, Map<String, Object> attrMap) {
        Object dataSource = attrMap.get("dataSource");
        Object cache = attrMap.get("cache");
        Object cacheKey = attrMap.get("cacheKey");
        Object time = attrMap.get("time");
        Object auth = attrMap.get("auth");
        Object mobile = attrMap.get("mobile");
        Object callbackApi = attrMap.get("callbackApi");
        return new LogicResource(this, moduleName, key, value.toString(), dataSource == null ? null : dataSource.toString(), cache == null ? DEFAULT_CACHE_STATE : Boolean.parseBoolean(cache.toString()), time == null ? DEFAULT_CACHE_TIME : Long.parseLong(time.toString()), cacheKey == null ? null : cacheKey.toString(), auth == null ? DEFAULT_AUTH_STATE : Boolean.parseBoolean(auth.toString()), mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile.toString()), callbackApi == null ? DEFAULT_CALLBACK_API_STATE : Boolean.parseBoolean(callbackApi.toString()));
    }

    public static class LogicResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport,
    AbstractResourceMapper.DataSourceResourceSupport {
        private final String dataSource;
        private final boolean cache;
        private final long time;
        private final String cacheKey;
        private final boolean auth;
        private final boolean mobile;
        private final boolean callbackApi;

        public LogicResource(AbstractResourceMapper<?> mapper, String moduleName, String key, Object path, String dataSource, Boolean cache, Long time, String cacheKey, Boolean auth, Boolean mobile, Boolean callbackApi) {
            super(mapper, moduleName, key, path);
            this.dataSource = dataSource;
            this.cache = cache;
            this.time = time;
            this.cacheKey = cacheKey;
            this.auth = auth;
            this.mobile = mobile;
            this.callbackApi = callbackApi;
        }

        @Override
        public String getDataSource() {
            return this.dataSource;
        }

        public boolean isCache() {
            return this.cache;
        }

        public long getTime() {
            return this.time;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public boolean getAuth() {
            return this.auth;
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }

        public boolean isCallbackApi() {
            return this.callbackApi;
        }
    }
}

