/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import com.alibaba.druid.DbType;
import java.util.Optional;
import org.dom4j.Element;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper
extends AbstractResourceMapper<SqlResource> {
    private static final Boolean DEFAULT_MOBILE_STATE = false;
    private final LiuLiConfigService liuLiConfigService;

    protected SqlMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        super(moduleMapper, applicationUtils);
        this.liuLiConfigService = liuLiConfigService;
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.SQL;
    }

    @Override
    public String getFileName() {
        return "sql.xml";
    }

    @Override
    public String getFolderName() {
        return "sqls";
    }

    @Override
    public SqlResource getValue(String alias) {
        DbType dbType = DynamicDataSource.getDbType();
        Object newAlias = switch (dbType) {
            case DbType.oracle -> alias + "_oracle";
            case DbType.mysql -> alias + "_mysql";
            default -> alias;
        };
        SqlResource resource = (SqlResource)super.getValue((String)newAlias);
        if (Optional.ofNullable(resource).isEmpty() && dbType != DbType.sqlserver) {
            resource = (SqlResource)super.getValue(alias);
        }
        if (Optional.ofNullable(resource).isEmpty()) {
            Object realAlias = newAlias;
            JSONObject liuliContent = this.liuLiConfigService.get((String)newAlias);
            if (Optional.ofNullable(liuliContent).isEmpty() && dbType != DbType.sqlserver) {
                realAlias = alias;
                liuliContent = this.liuLiConfigService.get(alias);
            }
            if (liuliContent != null) {
                JSONObject globalProp = liuliContent.getJSONObject("globalProp");
                resource = new SqlResource(globalProp.optString("module", null), (String)realAlias, "cloudData", liuliContent.optString("mobile", null));
            }
        }
        return resource;
    }

    @Override
    protected SqlResource buildResource(String moduleName, String key, Object value, Element element) {
        String mobile = element.attributeValue("mobile");
        return new SqlResource(moduleName, key, value.toString(), mobile);
    }

    public static class SqlResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport {
        private final boolean mobile;

        public SqlResource(String moduleName, String key, Object path, String mobile) {
            super(moduleName, key, path);
            this.mobile = mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile);
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }
    }
}

