/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.plugins.io.IOTools;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModuleMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleMapper.class);
    private static final String MODULE_FILE_NAME = "module.xml";
    private static final String MODE_NAME = "module";
    private static final String IMPORT_NAME = "import";
    private static final String BASE_TENANT_PATH = "/tenants/";
    private static Map<String, Map<String, String>> map;

    public ModuleMapper() {
        map = new LinkedHashMap<String, Map<String, String>>(8);
        this.loadModuleBootstrap(MODULE_FILE_NAME, true);
    }

    public Map<String, Map<String, String>> getMap() {
        return map;
    }

    private void parseTenantModule() {
        File directory;
        File[] directoryList;
        URL url = ModuleMapper.class.getResource(BASE_TENANT_PATH);
        if (url != null && (directoryList = (directory = new File(url.getPath())).listFiles()) != null) {
            for (File item : directoryList) {
                if (!item.isDirectory()) continue;
                String moduleName = item.getName();
                HashMap<String, String> module = new HashMap<String, String>(3);
                module.put("path", "tenants");
                map.put(moduleName, module);
                LOGGER.info(">>> \u6a21\u5757\uff1a[" + moduleName + "]\u52a0\u8f7d\u5b8c\u6210");
            }
        }
    }

    private void parseImportModule(Element root) {
        List ite = root.elements(IMPORT_NAME);
        if (!ite.isEmpty()) {
            for (Element elm : ite) {
                String name = elm.attribute("name").getValue();
                LOGGER.info("====\u4ece\u6a21\u5757\u96c6[" + name + "]\u5bfc\u5165\u6a21\u5757====");
                this.loadModuleBootstrap(name + "/module.xml", false);
            }
        }
    }

    private void parseProjectModule(Element root) {
        Iterator it = root.elementIterator(MODE_NAME);
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            String path = elm.attributeValue("path");
            HashMap<String, String> module = new HashMap<String, String>(3);
            module.put("upload", upload);
            module.put("path", path);
            map.put(name, module);
            LOGGER.info(">>> \u6a21\u5757\uff1a[" + name + "]\u52a0\u8f7d\u5b8c\u6210");
        }
    }

    private void loadModuleBootstrap(String path, boolean isRoot) {
        IOTools.getStream((String)path, stream -> {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(stream);
                Element root = document.getRootElement();
                this.parseImportModule(root);
                if (isRoot) {
                    LOGGER.info("====\u4ece\u79df\u6237\u76ee\u5f55\u5bfc\u5165\u6a21\u5757====");
                    this.parseTenantModule();
                    LOGGER.info("====\u4ece\u672c\u5730\u76ee\u5f55\u5bfc\u5165\u6a21\u5757====");
                }
                this.parseProjectModule(root);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }, errorPath -> {
            throw new ServiceException("\u6a21\u5757\u5b9a\u4e49\u6587\u4ef6[module.xml]\u672a\u627e\u5230\uff0c\u76f8\u5173\u8def\u5f84\uff1a" + errorPath, Integer.valueOf(506));
        });
    }
}

