/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.util.Optional;
import org.dom4j.Element;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class LogicMapper
extends AbstractResourceMapper<LogicResource> {
    private static final Boolean DEFAULT_CACHE_STATE = false;
    private static final Long DEFAULT_CACHE_TIME = 60L;
    private static final Boolean DEFAULT_AUTH_STATE = true;
    private static final Boolean DEFAULT_MOBILE_STATE = false;
    private static final Boolean DEFAULT_CALLBACK_API_STATE = false;
    private final LiuLiConfigService liuLiConfigService;

    protected LogicMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        super(moduleMapper, applicationUtils);
        this.liuLiConfigService = liuLiConfigService;
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.LOGIC;
    }

    @Override
    public String getFileName() {
        return "logic.xml";
    }

    @Override
    public String getFolderName() {
        return "logics";
    }

    @Override
    public LogicResource getValue(String alias) {
        JSONObject liuliContent;
        LogicResource resource = (LogicResource)super.getValue(alias);
        if (Optional.ofNullable(resource).isEmpty() && (liuliContent = this.liuLiConfigService.get(alias)) != null) {
            JSONObject globalProp = liuliContent.getJSONObject("globalProp");
            resource = new LogicResource(globalProp.optString("module", null), alias, "cloudData", liuliContent.optString("dataSource", null), liuliContent.optString("cache", null), liuliContent.optString("time", null), liuliContent.optString("cacheKey", null), liuliContent.optString("auth", null), liuliContent.optString("mobile", null), liuliContent.optString("callbackApi", null));
        }
        return resource;
    }

    @Override
    protected LogicResource buildResource(String moduleName, String key, Object value, Element element) {
        String dataSource = element.attributeValue("dataSource");
        String cache = element.attributeValue("cache");
        String cacheKey = element.attributeValue("cacheKey");
        String time = element.attributeValue("time");
        String auth = element.attributeValue("auth");
        String mobile = element.attributeValue("mobile");
        String callbackApi = element.attributeValue("callbackApi");
        return new LogicResource(moduleName, key, value.toString(), dataSource, cache, time, cacheKey, auth, mobile, callbackApi);
    }

    public static class LogicResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport {
        private final String dataSource;
        private final boolean cache;
        private final long time;
        private final String cacheKey;
        private final boolean auth;
        private final boolean mobile;
        private final boolean callbackApi;

        public LogicResource(String moduleName, String key, Object path, String dataSource, String cache, String time, String cacheKey, String auth, String mobile, String callbackApi) {
            super(moduleName, key, path);
            this.dataSource = dataSource;
            this.cache = cache == null ? DEFAULT_CACHE_STATE : Boolean.parseBoolean(cache);
            this.time = time == null ? DEFAULT_CACHE_TIME : Long.parseLong(time);
            this.cacheKey = cacheKey;
            this.auth = auth == null ? DEFAULT_AUTH_STATE : Boolean.parseBoolean(auth);
            this.mobile = mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile);
            this.callbackApi = callbackApi == null ? DEFAULT_CALLBACK_API_STATE : Boolean.parseBoolean(callbackApi);
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public boolean isCache() {
            return this.cache;
        }

        public long getTime() {
            return this.time;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public boolean getAuth() {
            return this.auth;
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }

        public boolean isCallbackApi() {
            return this.callbackApi;
        }
    }
}

