/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.plugins.io.IOTools;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Component
public abstract class AbstractResourceMapper<T extends CommonResource> {
    public static final String TENANT_MODULE_NAME = "tenants";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceMapper.class);
    private static final boolean IS_JUNIT_TEST = AbstractResourceMapper.isJUnitTest();
    private final ApplicationUtils applicationUtils;
    private final ModuleMapper moduleMapper;
    protected Map<String, T> map;

    protected AbstractResourceMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils) {
        this.moduleMapper = moduleMapper;
        this.applicationUtils = applicationUtils;
    }

    private static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    public abstract ResourceType getResType();

    public abstract String getFileName();

    public abstract String getFolderName();

    @PostConstruct
    protected void loadMap() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, T>(36);
            this.putMapByRoot();
            this.moduleMapper.getMap().forEach((key, value) -> {
                String path = (String)value.get("path");
                try {
                    this.putMapByModule((String)key, path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    protected void putMapByRoot() {
        this.putMapByModule(null, null);
    }

    protected void putMapByModule(String name, String parent) {
        String fileName = this.getFileName();
        ResourceType resType = this.getResType();
        Object str = parent == null ? (name == null ? fileName : name + "/" + fileName) : parent + "/" + name + "/" + fileName;
        IOTools.getStream((String)str, stream -> {
            Document document;
            SAXReader reader = new SAXReader();
            try {
                document = reader.read(stream);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            Element root = document.getRootElement();
            Iterator item = root.elementIterator(resType.getValue());
            while (item.hasNext()) {
                Element element = (Element)item.next();
                this.appendRes(element, name, parent);
            }
        });
    }

    public Map<String, T> getAllMap() {
        return this.map;
    }

    public T getValue(String key) {
        String alias = this.getAlias(key);
        if (this.map.containsKey(alias)) {
            return (T)((CommonResource)this.map.get(key));
        }
        return null;
    }

    protected String getAlias(String key) {
        String tenantName = this.applicationUtils.getTenantName();
        if (tenantName.equals("standard") || tenantName.equals("standard_test")) {
            return key;
        }
        String alias = key + "@" + tenantName;
        return this.map.containsKey(alias) ? alias : key;
    }

    protected void appendRes(Element element, String moduleName, String parentModuleName) {
        Object value;
        if (moduleName == null) {
            moduleName = "";
        }
        Object key = element.attribute("alias").getValue();
        ResourceType resType = this.getResType();
        if (IS_JUNIT_TEST && moduleName.startsWith("test_")) {
            key = "test_" + (String)key;
        }
        if (Objects.equals(parentModuleName, TENANT_MODULE_NAME)) {
            key = (String)key + "@" + moduleName;
        }
        if (this.map.containsKey(key)) {
            throw new ServiceException(resType + "\u522b\u540d[" + (String)key + "]\u5df2\u5b58\u5728", Integer.valueOf(506));
        }
        Attribute pathAttribute = element.attribute("path");
        if (pathAttribute != null) {
            Object path = pathAttribute.getValue();
            String folderName = this.getFolderName();
            value = path = (parentModuleName == null ? moduleName + "/" + folderName + "/" : parentModuleName + "/" + moduleName + "/" + folderName + "/") + (String)path;
        } else {
            String className = element.attribute("class").getValue();
            value = this.getClassByName(className, moduleName);
        }
        if (value != null) {
            this.map.put((String)key, this.buildResource(moduleName, (String)key, value, element));
        }
    }

    protected T buildResource(String moduleName, String key, Object value, Element element) {
        return (T)new CommonResource(moduleName, key, value);
    }

    private Object getClassByName(String className, String moduleName) {
        try {
            Class<?> c = Class.forName(className);
            Object obj = this.isSpringBean(c) ? SpringUtils.getBean(c) : c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            if (moduleName == null) {
                moduleName = "/";
            }
            LOGGER.warn("\u672a\u627e\u5230\u7c7b, \u6a21\u5757=" + moduleName + ", \u7c7b=" + ex.getMessage());
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isSpringBean(Class<?> c) {
        for (Annotation annotation : c.getAnnotations()) {
            if (annotation.annotationType() != Component.class && annotation.annotationType() != Service.class && annotation.annotationType() != RestController.class) continue;
            return true;
        }
        return false;
    }

    public static class CommonResource {
        private final String moduleName;
        private final String alias;
        private final Object path;

        CommonResource(String moduleName, String alias, Object path) {
            this.moduleName = moduleName;
            this.alias = alias;
            this.path = path;
        }

        public String getAlias() {
            return this.alias;
        }

        public Object getPath() {
            return this.path;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }

    public static interface MobileResourceSupport {
        public boolean isMobile();
    }
}

