/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.core;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.plugins.io.IOTools;
import com.af.v4.system.common.resource.enums.ResourceType;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public final class ResourceIndexer {
    public static final String DEFAULT_CLOUD_DATA_PATH_VALUE = "cloudData";
    private static Cache<String, String> LOGIC_CACHE;
    private static Cache<String, String> SQL_CACHE;
    private static EnvType envType;
    private static LiuLiConfigService LIU_LI_CONFIG_SERVICE;

    public ResourceIndexer(ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        envType = applicationUtils.getEnvType();
        LIU_LI_CONFIG_SERVICE = liuLiConfigService;
    }

    public static void clearLogicCache() {
        LOGIC_CACHE.clear();
    }

    public static void clearSqlCache() {
        SQL_CACHE.clear();
    }

    public static String getString(ResourceType resourceType, String alias, String filePath) {
        Object source = null;
        switch (resourceType) {
            case LOGIC: {
                if (filePath.equals(DEFAULT_CLOUD_DATA_PATH_VALUE)) {
                    return LIU_LI_CONFIG_SERVICE.get(alias).getString("source");
                }
                if (envType == EnvType.PROD || envType == EnvType.PREVIEW) {
                    source = (String)LOGIC_CACHE.get((Object)alias);
                }
                if (source == null) {
                    source = IOTools.readText((String)filePath);
                    source = ((String)source).replace("\r\n", "\n");
                    if (envType == EnvType.PROD || envType == EnvType.PREVIEW) {
                        LOGIC_CACHE.put((Object)alias, source);
                    }
                }
                return source;
            }
            case SQL: {
                if (filePath.equals(DEFAULT_CLOUD_DATA_PATH_VALUE)) {
                    return LIU_LI_CONFIG_SERVICE.get(alias).getString("source");
                }
                if (envType == EnvType.PROD || envType == EnvType.PREVIEW) {
                    source = (String)SQL_CACHE.get((Object)alias);
                }
                if (source == null) {
                    source = IOTools.readText((String)filePath);
                    source = ((String)source).replace("\r\n", "\n");
                    if (((String)(source = "$" + (String)source)).contains("${")) {
                        source = ((String)source).replace("${", "{");
                    }
                    if (envType == EnvType.PROD || envType == EnvType.PREVIEW) {
                        SQL_CACHE.put((Object)alias, source);
                    }
                }
                return source;
            }
        }
        throw new ServiceException("\u9519\u8bef\u7684\u7f13\u5b58\u6570\u636e\u7c7b\u578b");
    }

    @PostConstruct
    public void init() {
        if (envType == EnvType.PROD || envType == EnvType.PREVIEW) {
            LOGIC_CACHE = CacheUtil.newLRUCache((int)100);
            SQL_CACHE = CacheUtil.newLRUCache((int)100);
        }
    }

    static {
        envType = null;
        LIU_LI_CONFIG_SERVICE = null;
    }
}

