package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.alibaba.druid.DbType;
import org.dom4j.Element;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * SQL映射器
 *
 * @author Mr.river
 */
@Component
public class SqlMapper extends AbstractResourceMapper<SqlMapper.SqlResource> {

    private static final Boolean DEFAULT_MOBILE_STATE = false;
    private final LiuLiConfigService liuLiConfigService;

    protected SqlMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        super(moduleMapper, applicationUtils);
        this.liuLiConfigService = liuLiConfigService;
    }


    @Override
    public ResourceType getResType() {
        return ResourceType.SQL;
    }

    @Override
    public String getFileName() {
        return "sql.xml";
    }

    @Override
    public String getFolderName() {
        return "sqls";
    }

    public SqlResource getValue(String alias) {
        DbType dbType = DynamicDataSource.getDbType();
        String newAlias = switch (dbType) {
            case oracle -> alias + "_oracle";
            case mysql -> alias + "_mysql";
            default -> alias;
        };
        SqlResource resource = super.getValue(newAlias);
        if (Optional.ofNullable(resource).isEmpty() && dbType != DbType.sqlserver) {
            resource = super.getValue(alias);
        }
        if (Optional.ofNullable(resource).isEmpty()) {
            String realAlias = newAlias;
            JSONObject liuliContent = liuLiConfigService.get(newAlias);
            if (Optional.ofNullable(liuliContent).isEmpty() && dbType != DbType.sqlserver) {
                realAlias = alias;
                liuliContent = liuLiConfigService.get(alias);
            }
            if (liuliContent != null) {
                JSONObject globalProp = liuliContent.getJSONObject("globalProp");
                resource = new SqlMapper.SqlResource(
                        globalProp.optString("module", null),
                        realAlias,
                        ResourceIndexer.DEFAULT_CLOUD_DATA_PATH_VALUE,
                        liuliContent.optString("mobile", null)
                );
            }
        }
        return resource;
    }

    @Override
    protected SqlMapper.SqlResource buildResource(String moduleName, String key, Object value, Element element) {
        // 是否支持手机端
        String mobile = element.attributeValue("mobile");

        return new SqlMapper.SqlResource(
                moduleName,
                key,
                value.toString(),
                mobile
        );
    }

    /**
     * Sql资源
     */
    public static class SqlResource extends CommonResource implements MobileResourceSupport {
        /**
         * 是否支持手机端
         */
        private final boolean mobile;

        public SqlResource(String moduleName, String key, Object path, String mobile) {
            super(moduleName, key, path);
            this.mobile = mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile);
        }

        public boolean isMobile() {
            return mobile;
        }
    }
}
