package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * 业务插件映射器
 *
 * @author Mr.river
 */
@Component
public class PluginMapper extends AbstractResourceMapper<AbstractResourceMapper.CommonResource> {

    public static Map<String, Object> pluginMap;

    protected PluginMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils) {
        super(moduleMapper, applicationUtils);
    }

    @Override
    protected void loadMap() {
        super.loadMap();
        pluginMap = getAllMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, object -> object.getValue().getPath()));
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.PLUGIN;
    }

    @Override
    public String getFileName() {
        return "plugins.xml";
    }

    @Override
    public String getFolderName() {
        return null;
    }
}
