/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.resource.config.ResourceConfig;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import com.alibaba.druid.DbType;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper
extends AbstractResourceMapper<SqlResource> {
    private static final Boolean DEFAULT_MOBILE_STATE = false;

    protected SqlMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.SQL;
    }

    @Override
    public String getFileName() {
        return "sql.xml";
    }

    @Override
    public String getFolderName() {
        return "sqls";
    }

    @Override
    public SqlResource getValue(String alias) {
        DbType dbType = DynamicDataSource.getDbType();
        Object newAlias = switch (dbType) {
            case DbType.oracle -> alias + "_oracle";
            case DbType.mysql -> alias + "_mysql";
            default -> alias;
        };
        SqlResource resource = (SqlResource)super.getValue((String)newAlias);
        if (resource.getPath() == null && dbType != DbType.sqlserver) {
            resource = (SqlResource)super.getValue(alias);
        }
        return resource;
    }

    @Override
    protected SqlResource buildResource(String key, Object value, Element element) {
        String mobile = element.attributeValue("mobile");
        return new SqlResource(key, value.toString(), mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile));
    }

    public static class SqlResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport {
        private final boolean mobile;

        public SqlResource(String key, Object path, boolean mobile) {
            super(key, path);
            this.mobile = mobile;
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }
    }
}

