/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.resource.config.ResourceConfig;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

@Component
public class LogicMapper
extends AbstractResourceMapper<LogicResource> {
    private static final Boolean DEFAULT_CACHE_STATE = false;
    private static final Long DEFAULT_CACHE_TIME = 60L;
    private static final Boolean DEFAULT_AUTH_STATE = true;
    private static final Boolean DEFAULT_MOBILE_STATE = false;

    protected LogicMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.LOGIC;
    }

    @Override
    public String getFileName() {
        return "logic.xml";
    }

    @Override
    public String getFolderName() {
        return "logics";
    }

    @Override
    protected LogicResource buildResource(String key, Object value, Element element) {
        String dataSource = element.attributeValue("dataSource");
        String cache = element.attributeValue("cache");
        String cacheKey = element.attributeValue("cacheKey");
        String time = element.attributeValue("time");
        String auth = element.attributeValue("auth");
        String mobile = element.attributeValue("mobile");
        return new LogicResource(key, value.toString(), dataSource, cache == null ? DEFAULT_CACHE_STATE : Boolean.parseBoolean(cache), time == null ? DEFAULT_CACHE_TIME : Long.parseLong(time), cacheKey, auth == null ? DEFAULT_AUTH_STATE : Boolean.parseBoolean(auth), mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile));
    }

    public static class LogicResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport {
        private final String dataSource;
        private final boolean cache;
        private final long time;
        private final String cacheKey;
        private final boolean auth;
        private final boolean mobile;

        public LogicResource(String key, Object path, String dataSource, boolean cache, long time, String cacheKey, boolean auth, boolean mobile) {
            super(key, path);
            this.dataSource = dataSource;
            this.cache = cache;
            this.time = time;
            this.cacheKey = cacheKey;
            this.auth = auth;
            this.mobile = mobile;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public boolean isCache() {
            return this.cache;
        }

        public long getTime() {
            return this.time;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public boolean getAuth() {
            return this.auth;
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }
    }
}

