package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.resource.config.ResourceConfig;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.alibaba.druid.DbType;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

/**
 * SQL映射器
 *
 * @author Mr.river
 */
@Component
public class SqlMapper extends AbstractResourceMapper<SqlMapper.SqlResource> {

    private static final Boolean DEFAULT_MOBILE_STATE = false;

    protected SqlMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }


    @Override
    public ResourceType getResType() {
        return ResourceType.SQL;
    }

    @Override
    public String getFileName() {
        return "sql.xml";
    }

    @Override
    public String getFolderName() {
        return "sqls";
    }

    public SqlResource getValue(String alias) {
        DbType dbType = DynamicDataSource.getDbType();
        String newAlias = switch (dbType) {
            case oracle -> alias + "_oracle";
            case mysql -> alias + "_mysql";
            default -> alias;
        };
        SqlResource resource = super.getValue(newAlias);
        if (resource.getPath() == null && dbType != DbType.sqlserver) {
            resource = super.getValue(alias);
        }
        return resource;
    }

    @Override
    protected SqlMapper.SqlResource buildResource(String key, Object value, Element element) {
        // 是否支持手机端
        String mobile = element.attributeValue("mobile");

        return new SqlMapper.SqlResource(
                key,
                value.toString(),
                mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile));
    }

    /**
     * Sql资源
     */
    public static class SqlResource extends CommonResource implements MobileResourceSupport {
        /**
         * 是否支持手机端
         */
        private final boolean mobile;

        public SqlResource(String key, Object path, boolean mobile) {
            super(key, path);
            this.mobile = mobile;
        }

        public boolean isMobile() {
            return mobile;
        }
    }
}
