package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.resource.config.ResourceConfig;
import com.af.v4.system.common.resource.enums.ResourceType;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

/**
 * logic映射器
 *
 * @author Mr.river
 */
@Component
public class LogicMapper extends AbstractResourceMapper<LogicMapper.LogicResource> {

    private static final Boolean DEFAULT_CACHE_STATE = false;
    private static final Long DEFAULT_CACHE_TIME = 60L;
    private static final Boolean DEFAULT_AUTH_STATE = true;
    private static final Boolean DEFAULT_MOBILE_STATE = false;

    protected LogicMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.LOGIC;
    }

    @Override
    public String getFileName() {
        return "logic.xml";
    }

    @Override
    public String getFolderName() {
        return "logics";
    }

    @Override
    protected LogicResource buildResource(String key, Object value, Element element) {
        // 所属数据源
        String dataSource = element.attributeValue("dataSource");
        // 是否缓存
        String cache = element.attributeValue("cache");
        // 自定义缓存Key
        String cacheKey = element.attributeValue("cacheKey");
        // 缓存时间
        String time = element.attributeValue("time");
        // 是否鉴权
        String auth = element.attributeValue("auth");
        // 是否支持手机端
        String mobile = element.attributeValue("mobile");

        return new LogicResource(
                key,
                value.toString(),
                dataSource,
                cache == null ? DEFAULT_CACHE_STATE : Boolean.parseBoolean(cache),
                time == null ? DEFAULT_CACHE_TIME : Long.parseLong(time),
                cacheKey,
                auth == null ? DEFAULT_AUTH_STATE : Boolean.parseBoolean(auth),
                mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile));
    }

    /**
     * Logic资源
     */
    public static class LogicResource extends CommonResource implements MobileResourceSupport {
        /**
         * 所属数据源
         */
        private final String dataSource;
        /**
         * 是否缓存
         */
        private final boolean cache;
        /**
         * 缓存时间
         */
        private final long time;
        /**
         * 自定义缓存Key
         */
        private final String cacheKey;
        /**
         * 是否鉴权
         */
        private final boolean auth;
        /**
         * 是否支持手机端
         */
        private final boolean mobile;

        public LogicResource(String key, Object path, String dataSource, boolean cache, long time, String cacheKey, boolean auth, boolean mobile) {
            super(key, path);
            this.dataSource = dataSource;
            this.cache = cache;
            this.time = time;
            this.cacheKey = cacheKey;
            this.auth = auth;
            this.mobile = mobile;
        }

        public String getDataSource() {
            return dataSource;
        }

        public boolean isCache() {
            return cache;
        }

        public long getTime() {
            return time;
        }

        public String getCacheKey() {
            return cacheKey;
        }

        public boolean getAuth() {
            return auth;
        }

        public boolean isMobile() {
            return mobile;
        }
    }
}
