/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import com.alibaba.druid.DbType;
import java.util.Map;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper
extends AbstractResourceMapper<String> {
    public SqlMapper(ModuleMapper moduleMapper, RedisService redisService) {
        super(moduleMapper, redisService);
    }

    @Override
    protected String getResType() {
        return "sql";
    }

    @Override
    protected String getFileName() {
        return "sql.xml";
    }

    @Override
    protected String getFolderName() {
        return "sqls";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        String mobile = element.attributeValue("mobile");
        res.put("mobile", mobile);
        return res;
    }

    @Override
    public AbstractResourceMapper.CommonResource<String> getValue(String alias) {
        DbType dbType = DbType.of((String)DynamicDataSource.getDruidDataSource().getDbType());
        Object newAlias = switch (dbType) {
            case DbType.oracle -> alias + "_oracle";
            case DbType.mysql -> alias + "_mysql";
            default -> alias;
        };
        AbstractResourceMapper.CommonResource<String> commonResource = super.getValue((String)newAlias);
        if (commonResource.getPath() == null && dbType != DbType.sqlserver) {
            commonResource = super.getValue(alias);
        }
        return commonResource;
    }
}

