/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.plugins.io.IOTools;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public record ResourceMapper(RedisService redisService) {
    private static final ConcurrentHashMap<String, String> CACHE_LOGIC_MAP;
    private static final ConcurrentHashMap<String, String> CACHE_SQL_MAP;
    private static final ConcurrentHashMap<String, String> CACHE_PROMPT_MAP;
    public static CACHE_MODE mode;

    public static void clearLogicCache() {
        CACHE_LOGIC_MAP.clear();
    }

    public static void clearSqlCache() {
        CACHE_SQL_MAP.clear();
    }

    public static void clearPromptCache() {
        CACHE_PROMPT_MAP.clear();
    }

    public String getString(ResourceType resourceType, String alias, String filePath) {
        switch (resourceType) {
            case LOGIC: {
                if (mode == CACHE_MODE.NORMAL && CACHE_LOGIC_MAP.containsKey(alias)) {
                    return CACHE_LOGIC_MAP.get(alias);
                }
                String source = IOTools.readText((String)filePath);
                source = source.replace("\r\n", "\n");
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_LOGIC_MAP.put(alias, source);
                }
                return source;
            }
            case SQL: {
                if (mode == CACHE_MODE.NORMAL && CACHE_SQL_MAP.containsKey(alias)) {
                    return CACHE_SQL_MAP.get(alias);
                }
                Object source = IOTools.readText((String)filePath);
                source = ((String)source).replace("\r\n", "\n");
                source = "$" + (String)source;
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_SQL_MAP.put(alias, (String)source);
                }
                return source;
            }
            case PROMPT: {
                if (mode == CACHE_MODE.NORMAL && CACHE_PROMPT_MAP.containsKey(alias)) {
                    return CACHE_PROMPT_MAP.get(alias);
                }
                String source = IOTools.readText((String)filePath);
                source = source.replace("\r\n", "\n");
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_PROMPT_MAP.put(alias, source);
                }
                return source;
            }
        }
        throw new ServiceException("\u9519\u8bef\u7684\u7f13\u5b58\u6570\u636e\u7c7b\u578b");
    }

    static {
        mode = CACHE_MODE.NORMAL;
        CACHE_LOGIC_MAP = new ConcurrentHashMap(10);
        CACHE_SQL_MAP = new ConcurrentHashMap(10);
        CACHE_PROMPT_MAP = new ConcurrentHashMap(10);
    }

    public static enum CACHE_MODE {
        NORMAL,
        DEBUG;

    }
}

