/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.resource.mapper.ResourceMapper;
import com.af.v4.system.plugins.io.IOTools;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModuleMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleMapper.class);
    private static final String MODULE_FILE_NAME = "module.xml";
    private static final String MODE_NAME = "module";
    private static final String MODE_PROPERTY_NAME = "mode";
    private static final String DEBUG_MODE = "debug";
    private static Map<String, Map<String, String>> map;

    public ModuleMapper() {
        this.loadMap();
    }

    public Map<String, Map<String, String>> getMap() {
        return map;
    }

    private void loadMap() {
        map = new LinkedHashMap<String, Map<String, String>>();
        IOTools.getStream((String)MODULE_FILE_NAME, stream -> {
            try {
                this.parseModule(stream);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }, errorPath -> {
            throw new ServiceException("\u6a21\u5757\u5b9a\u4e49\u6587\u4ef6module.xml\u672a\u627e\u5230\uff0c\u76f8\u5173\u8def\u5f84\uff1a" + errorPath);
        });
    }

    private void parseModule(InputStream stream) throws DocumentException {
        File directory;
        File[] directoryList;
        SAXReader reader = new SAXReader();
        Document document = reader.read(stream);
        Element root = document.getRootElement();
        String mode = root.attributeValue(MODE_PROPERTY_NAME);
        if (mode != null && mode.equals(DEBUG_MODE)) {
            LOGGER.warn("\u68c0\u6d4b\u5230\u5df2\u5728module.xml\u4e2d\u5f00\u542f\u8c03\u8bd5\u6a21\u5f0f(mode='debug')\uff0c\u4e1a\u52a1\u8d44\u6e90\u61d2\u52a0\u8f7d\u4f18\u5316\u5df2\u5173\u95ed");
            LOGGER.warn("\u751f\u4ea7\u73af\u5883\u4e0b\u5efa\u8bae\u5173\u95ed\u8be5\u6a21\u5f0f\uff0c\u4ee5\u907f\u514d\u6bcf\u6b21\u8bbf\u95ee\u4e1a\u52a1\u8d44\u6e90\u6240\u5e26\u6765\u7684\u4e0d\u5fc5\u8981\u7684IO\u6d88\u8017");
            ResourceMapper.mode = ResourceMapper.CACHE_MODE.DEBUG;
        } else {
            LOGGER.info("\u4e1a\u52a1\u8d44\u6e90\u61d2\u52a0\u8f7d\u4f18\u5316\u5df2\u5f00\u542f\uff0cLogic/SQL\u7f13\u5b58\u6210\u529f\uff0c\u53ef\u4ee5\u901a\u8fc7rs/logic/clear\u5f3a\u5236\u6e05\u7406\u7f13\u5b58");
        }
        URL url = ModuleMapper.class.getResource("/filiale/");
        if (url != null && (directoryList = (directory = new File(url.getPath())).listFiles()) != null) {
            for (File item : directoryList) {
                if (!item.isDirectory()) continue;
                String name = item.getName();
                HashMap<String, String> module = new HashMap<String, String>(3);
                module.put("name", name);
                module.put("path", "filiale");
                map.put(name, module);
                LOGGER.info("\u5206\u516c\u53f8\u6a21\u5757\uff1a[" + name + "]\u52a0\u8f7d\u5b8c\u6210");
            }
        }
        Iterator it = root.elementIterator(MODE_NAME);
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            String path = elm.attributeValue("path");
            HashMap<String, String> module = new HashMap<String, String>(3);
            module.put("name", name);
            module.put("upload", upload);
            module.put("path", path);
            map.put(name, module);
            LOGGER.info("\u6a21\u5757\uff1a[" + name + "]\u52a0\u8f7d\u5b8c\u6210");
        }
    }
}

