package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.redis.RedisService;
import com.alibaba.druid.DbType;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * SQL映射器
 *
 * @author Mr.river
 */
@Component
public class SqlMapper extends AbstractResourceMapper<String> {

    public SqlMapper(ModuleMapper moduleMapper, RedisService redisService) {
        super(moduleMapper, redisService);
    }


    @Override
    protected String getResType() {
        return "sql";
    }

    @Override
    protected String getFileName() {
        return "sql.xml";
    }

    @Override
    protected String getFolderName() {
        return "sqls";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        // 追加元素
        String mobile = element.attributeValue("mobile");
        res.put("mobile", mobile);
        return res;
    }

    public CommonResource<String> getValue(String alias) {
        DbType dbType = DbType.of(DynamicDataSource.getDruidDataSource().getDbType());
        String newAlias = switch (dbType) {
            case oracle -> alias + "_oracle";
            case mysql -> alias + "_mysql";
            default -> alias;
        };
        CommonResource<String> commonResource = super.getValue(newAlias);
        if (commonResource.getPath() == null && dbType != DbType.sqlserver) {
            commonResource = super.getValue(alias);
        }
        return commonResource;
    }
}
