package com.af.v4.system.common.redis.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 设置最大重试次数（默认 3）
 * 可标注在类或方法上
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface MaxRetry {
    /**
     * 最大允许的重试次数
     */
    int value() default 3;
}
