package com.af.v4.system.common.redis.core;

import org.json.JSONObject;

/**
 * Redis 队列消息处理接口
 * <p>
 * 实现该接口可用于通过配置方式初始化消费者队列，无需手动注册回调。
 * 队列启动时将自动识别并调用此接口中的方法。
 */
public interface FastCacheQueueProcess {

    /**
     * 业务处理逻辑，返回业务结果
     * @param data 消息内容
     * @return 业务返回值
     */
    Object onProcess(JSONObject data);

    /**
     * 消费成功处理逻辑（带业务返回值）
     *
     * @param data 消息内容
     * @param result 业务返回值
     */
    default void onSuccess(JSONObject data, Object result) {}

    /**
     * 消费失败处理逻辑（包括抛出异常情况）
     *
     * @param data 消息内容
     * @param ex   抛出的异常
     */
    default void onFailure(JSONObject data, Exception ex) {}

    /**
     * 消息重试前处理逻辑
     *
     * @param data         消息内容
     * @param retryContext 重试上下文，包含重试次数等信息
     */
    default void beforeRetry(JSONObject data, JSONObject retryContext) {}
}
