/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.redis;

import com.af.v4.system.common.redis.utils.DistributedLockUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.options.KeysScanOptions;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisService.class);
    private final RedissonClient redissonClient;
    private final DistributedLockUtil distributedLockUtil;

    public RedisService(RedissonClient REDISSON_CLIENT, DistributedLockUtil distributedLockUtil) {
        this.redissonClient = REDISSON_CLIENT;
        this.distributedLockUtil = distributedLockUtil;
    }

    public <T> void set(String key, T value) {
        this.set(key, value, -1);
    }

    public <T> void set(String key, T value, Object timeoutSec) {
        Object realValue = (value instanceof JSONObject || value instanceof JSONArray) && value.toString() != null ? value.toString() : value;
        long timeoutSecValue = Long.parseLong(timeoutSec.toString());
        RBucket rBucket = this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        if (timeoutSecValue > 0L) {
            rBucket.set(realValue, Duration.ofSeconds(timeoutSecValue));
        } else {
            rBucket.set(realValue);
        }
    }

    public <T> void setHash(String hashKey, Map<String, T> value) {
        this.setHash(hashKey, value, -1);
    }

    public <T> void setHash(String hashKey, Map<String, T> value, Object timeoutSec) {
        long timeoutSecValue = Long.parseLong(timeoutSec.toString());
        RMap rMap = this.redissonClient.getMap(hashKey);
        rMap.putAll(value);
        if (timeoutSecValue > 0L) {
            rMap.expire(Duration.ofSeconds(timeoutSecValue));
        }
    }

    public JSONObject getHash(String hashKey) {
        return new JSONObject((Map)this.redissonClient.getMap(hashKey));
    }

    public <T> T getHash(String hashKey, String key) {
        RMap map = this.redissonClient.getMap(hashKey);
        return (T)map.get((Object)key);
    }

    public <T> void setHashKey(String hashKey, String key, T value) {
        RMap map = this.redissonClient.getMap(hashKey);
        map.put((Object)key, value);
    }

    public void deleteHashKey(String hashKey, String key) {
        this.redissonClient.getMap(hashKey).remove((Object)key);
    }

    public Boolean hasHashKey(String hashKey, String key) {
        return this.redissonClient.getMap(hashKey).containsKey((Object)key);
    }

    public <T> T syncLock(String key, Integer leaseTime, Supplier<T> supplier) {
        return this.distributedLockUtil.syncLock(key, leaseTime, supplier);
    }

    public <T> T syncLock(String key, Supplier<T> supplier) {
        return this.distributedLockUtil.syncLock(key, supplier);
    }

    public <T> T lock(String key, Integer waitTime, Integer leaseTime, Supplier<T> supplier) throws InterruptedException {
        return this.distributedLockUtil.lock(key, waitTime, leaseTime, supplier);
    }

    public <T> T lock(String key, Supplier<T> supplier) throws InterruptedException {
        return this.distributedLockUtil.lock(key, supplier);
    }

    public void lock(String key, Integer waitTime, Integer leaseTime, Runnable runnable) throws InterruptedException {
        this.lock(key, waitTime, leaseTime, () -> {
            runnable.run();
            return null;
        });
    }

    public void lock(String key, Runnable runnable) throws InterruptedException {
        this.lock(key, () -> {
            runnable.run();
            return null;
        });
    }

    public <T> T get(String key) {
        String resultStr;
        RBucket bucket = this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        Object result = bucket.get();
        Object realValue = result instanceof String ? ((resultStr = (String)result).startsWith("{") && resultStr.endsWith("}") ? new JSONObject(resultStr) : (resultStr.startsWith("[") && resultStr.endsWith("]") ? new JSONArray(resultStr) : result)) : result;
        return (T)realValue;
    }

    public boolean hasKey(String key) {
        return this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).isExists();
    }

    public void delete(String key) {
        this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).delete();
    }

    public void deleteList(Iterable<String> keys) {
        keys.forEach(this::delete);
    }

    public void deleteList(JSONArray keys) {
        ArrayList<String> deleteIds = new ArrayList<String>(keys.length());
        keys.forEach(item -> deleteIds.add(item.toString()));
        this.deleteList(deleteIds);
    }

    public Iterable<String> getKeys(String pattern) {
        RKeys keys = this.redissonClient.getKeys();
        return keys.getKeys(KeysScanOptions.defaults().pattern(pattern));
    }

    public RTopic getTopic(String topicName) {
        return this.redissonClient.getTopic(topicName, (Codec)JsonJacksonCodec.INSTANCE);
    }

    public RBlockingQueue<String> getBlockingQueue(String queueName) {
        return this.redissonClient.getBlockingQueue(queueName);
    }
}

