/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.redis.utils;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DistributedLockUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockUtil.class);
    private static final int DEFAULT_WAIT_TIME = 5;
    private static final int DEFAULT_LEASE_TIME = 20;
    private final RedissonClient redissonClient;

    public DistributedLockUtil(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public <T> T syncLock(String key, Integer leaseTime, Supplier<T> supplier) {
        try {
            return this.executeWithLock(key, 0, leaseTime, supplier, true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T lock(String key, Integer waitTime, Integer leaseTime, Supplier<T> supplier) throws InterruptedException {
        return this.executeWithLock(key, waitTime, leaseTime, supplier, false);
    }

    public <T> T syncLock(String key, Supplier<T> supplier) {
        return this.syncLock(key, 20, supplier);
    }

    public <T> T lock(String key, Supplier<T> supplier) throws InterruptedException {
        return this.lock(key, 5, 20, supplier);
    }

    private <T> T executeWithLock(String key, Integer waitTime, Integer leaseTime, Supplier<T> supplier, boolean isBlocking) throws InterruptedException {
        RLock lock = this.redissonClient.getLock("LOCK-" + key);
        boolean isLock = false;
        try {
            if (isBlocking) {
                lock.lock((long)leaseTime.intValue(), TimeUnit.SECONDS);
                isLock = true;
            } else {
                isLock = lock.tryLock((long)waitTime.intValue(), (long)leaseTime.intValue(), TimeUnit.SECONDS);
            }
            if (isLock) {
                T t = supplier.get();
                return t;
            }
            try {
                throw new InterruptedException("\u83b7\u53d6\u9501\u8d85\u65f6\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u9501\uff1a" + key);
            }
            catch (InterruptedException e) {
                LOGGER.error("\u9501\u64cd\u4f5c\u5931\u8d25\uff1a{}\uff0c\u539f\u56e0\uff1a{}", (Object)lock.getName(), (Object)e.getMessage());
                throw e;
            }
        }
        finally {
            if (isLock && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }
}

