/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.redis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisService.class);
    private final RedissonClient redissonClient;

    public RedisService(RedissonClient REDISSON_CLIENT) {
        this.redissonClient = REDISSON_CLIENT;
    }

    public <T> void set(String key, T value) {
        this.set(key, value, -1);
    }

    public <T> void set(String key, T value, Object timeoutSec) {
        long timeoutSecValue = Long.parseLong(timeoutSec.toString());
        RBucket rBucket = this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        if (timeoutSecValue > 0L) {
            rBucket.set(value, Duration.ofSeconds(timeoutSecValue));
        } else {
            rBucket.set(value);
        }
    }

    public <T> void setHash(String hashKey, Map<String, T> value) {
        this.setHash(hashKey, value, -1);
    }

    public <T> void setHash(String hashKey, Map<String, T> value, Object timeoutSec) {
        long timeoutSecValue = Long.parseLong(timeoutSec.toString());
        RMap rMap = this.redissonClient.getMap(hashKey);
        rMap.putAll(value);
        if (timeoutSecValue > 0L) {
            rMap.expire(Duration.ofSeconds(timeoutSecValue));
        }
    }

    public JSONObject getHash(String hashKey) {
        return new JSONObject((Map)this.redissonClient.getMap(hashKey));
    }

    public <T> T getHash(String hashKey, String key) {
        RMap map = this.redissonClient.getMap(hashKey);
        return (T)map.get((Object)key);
    }

    public <T> void setHashKey(String hashKey, String key, T value) {
        RMap map = this.redissonClient.getMap(hashKey);
        map.put((Object)key, value);
    }

    public void deleteHashKey(String hashKey, String key) {
        this.redissonClient.getMap(hashKey).remove((Object)key);
    }

    public Boolean hasHashKey(String hashKey, String key) {
        return this.redissonClient.getMap(hashKey).containsKey((Object)key);
    }

    public void lock(String key, Runnable runnable) {
        this.lock(key, (Integer)10, (Integer)20, runnable);
    }

    public void lock(String key, Integer waitTime, Integer leaseTime, Runnable runnable) {
        this.lock(key, waitTime, leaseTime, () -> {
            runnable.run();
            return null;
        });
    }

    public <T> T lock(String key, Supplier<T> supplier) {
        return this.lock(key, (Integer)10, (Integer)20, supplier);
    }

    public <T> T lock(String key, Integer waitTime, Integer leaseTime, Supplier<T> supplier) {
        RLock lock = this.redissonClient.getLock("LOCK-" + key);
        try {
            boolean isLock = lock.tryLock((long)waitTime.intValue(), (long)leaseTime.intValue(), TimeUnit.SECONDS);
            if (isLock) {
                T t = supplier.get();
                return t;
            }
            try {
                throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
            }
            catch (InterruptedException e) {
                throw new RuntimeException("\u9501" + lock.getName() + "\u83b7\u53d6\u5931\u8d25", e);
            }
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public <T> T get(String key) {
        RBucket bucket = this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        return (T)bucket.get();
    }

    public boolean hasKey(String key) {
        return this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).isExists();
    }

    public void delete(String key) {
        this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).delete();
    }

    public void deleteList(Iterable<String> keys) {
        keys.forEach(this::delete);
    }

    public void deleteList(JSONArray keys) {
        ArrayList<String> deleteIds = new ArrayList<String>(keys.length());
        keys.forEach(item -> deleteIds.add(item.toString()));
        this.deleteList(deleteIds);
    }

    public Iterable<String> getKeys(String Pattern) {
        RKeys keys = this.redissonClient.getKeys();
        return keys.getKeysByPattern(Pattern);
    }

    public RTopic getTopic(String topicName) {
        return this.redissonClient.getTopic(topicName, (Codec)JsonJacksonCodec.INSTANCE);
    }
}

