/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.redis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisService.class);
    private final RedissonClient REDISSON_CLIENT;

    public RedisService(RedissonClient REDISSON_CLIENT) {
        this.REDISSON_CLIENT = REDISSON_CLIENT;
    }

    public <T> void set(String key, T value) {
        this.set(key, value, -1L);
    }

    public <T> void set(String key, T value, long timeoutSec) {
        RBucket rBucket = this.REDISSON_CLIENT.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        if (timeoutSec > 0L) {
            rBucket.set(value, timeoutSec, TimeUnit.SECONDS);
        } else {
            rBucket.set(value);
        }
    }

    public <T> void setHash(String hashKey, Map<String, T> value) {
        this.setHash(hashKey, value, -1L);
    }

    public <T> void setHash(String hashKey, Map<String, T> value, long timeoutSec) {
        RMap rMap = this.REDISSON_CLIENT.getMap(hashKey);
        rMap.putAll(value);
        if (timeoutSec > 0L) {
            rMap.expire(Duration.ofSeconds(timeoutSec));
        }
    }

    public JSONObject getHash(String hashKey) {
        return new JSONObject((Map)this.REDISSON_CLIENT.getMap(hashKey));
    }

    public <T> T getHash(String hashKey, String key) {
        RMap map = this.REDISSON_CLIENT.getMap(hashKey);
        return (T)map.get((Object)key);
    }

    public <T> void setHashKey(String hashKey, String key, T value) {
        RMap map = this.REDISSON_CLIENT.getMap(hashKey);
        map.put((Object)key, value);
    }

    public void deleteHashKey(String hashKey, String key) {
        this.REDISSON_CLIENT.getMap(hashKey).remove((Object)key);
    }

    public Boolean hasHashKey(String hashKey, String key) {
        return this.REDISSON_CLIENT.getMap(hashKey).containsKey((Object)key);
    }

    public void lock(String key, Runnable runnable) {
        this.lock(key, 10, 20, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, Integer waitTime, Integer leaseTime, Runnable runnable) {
        block7: {
            RLock lock = this.REDISSON_CLIENT.getLock("LOCK-" + key);
            try {
                boolean isLock = lock.tryLock((long)waitTime.intValue(), (long)leaseTime.intValue(), TimeUnit.SECONDS);
                if (isLock) {
                    runnable.success();
                    break block7;
                }
                throw new RuntimeException("\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
            }
            catch (InterruptedException e) {
                LOGGER.error("\u9501" + lock.getName() + "\u83b7\u53d6\u5931\u8d25");
                e.printStackTrace();
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
    }

    public <T> T get(String key) {
        RBucket bucket = this.REDISSON_CLIENT.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        return (T)bucket.get();
    }

    public boolean hasKey(String key) {
        return this.REDISSON_CLIENT.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).isExists();
    }

    public void delete(String key) {
        this.REDISSON_CLIENT.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).delete();
    }

    public void deleteList(Iterable<String> keys) {
        keys.forEach(this::delete);
    }

    public void deleteList(JSONObject keys) {
        this.deleteList(new ArrayList<String>(keys.keySet()));
    }

    @FunctionalInterface
    public static interface Runnable {
        public void success();
    }
}

