package com.af.v4.system.common.queryparams.enums;

import java.util.stream.Stream;

/**
 * 表单校验类型
 *
 * @author Mr.river
 */
public enum RuleTypeEnum {
    //字符串
    STRING("string"),
    //数字
    NUMBER("number"),
    //布尔值
    BOOLEAN("boolean"),
    //正则表达式
    REGEXP("regexp"),
    //整数
    INTEGER("integer"),
    //小数
    FLOAT("float"),
    //数组或集合
    ARRAY("array"),
    //日期
    DATE("date"),
    //邮箱
    EMAIL("email");

    private final String value;

    RuleTypeEnum(String value) {
        this.value = value;
    }

    public static RuleTypeEnum toType(String value) {
        return Stream.of(RuleTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
