package com.af.v4.system.common.plugins.other;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;

public class AESTools {
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    public static String encrypt(String content, String encryptKey) throws Exception {
        return aesEncrypt(content, encryptKey);
    }

    public static String decrypt(String content, String encryptKey) throws Exception {
        return aesDecrypt(content, encryptKey);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(Cipher.ENCRYPT_MODE, generateKey(encryptKey));
        return cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return Base64Tools.encode(aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(Cipher.DECRYPT_MODE, generateKey(decryptKey));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes, StandardCharsets.UTF_8);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return (encryptStr == null || encryptStr.isEmpty()) ? null : aesDecryptByBytes(Base64Tools.decodeBuffer(encryptStr), decryptKey);
    }

    private static SecretKeySpec generateKey(String key) throws NoSuchAlgorithmException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        return new SecretKeySpec(key.getBytes(), "AES");
    }
}
