/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTaskProcessor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchTaskProcessor.class);

    private int calculateChunkSize(int listSize, TaskType taskType) {
        int availableCores = 4;
        int result = taskType == TaskType.CPU_INTENSIVE ? Math.max(1, listSize / (availableCores + 1)) : Math.max(1, listSize / (availableCores * 2 + 1));
        return result;
    }

    public JSONObject process(List<T> items, TaskType taskType, Consumer<T> taskHandler, Function<List<T>, List<T>> preProcessor, Consumer<T> successCallback, Consumer<T> failureCallback) {
        int chunkSize = this.calculateChunkSize(items.size(), taskType);
        List<T> processedItems = preProcessor != null ? preProcessor.apply(items) : items;
        List<List<T>> chunks = this.splitList(processedItems, chunkSize);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        JSONObject result = new JSONObject();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger failureCount = new AtomicInteger(0);
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            for (List chunk : chunks) {
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    for (Object item : chunk) {
                        try {
                            taskHandler.accept(item);
                            successCount.incrementAndGet();
                            if (successCallback == null) continue;
                            successCallback.accept(item);
                        }
                        catch (Exception e) {
                            failureCount.incrementAndGet();
                            if (failureCallback != null) {
                                failureCallback.accept(item);
                            }
                            LOGGER.error("Error processing task: {}", item, (Object)e);
                        }
                    }
                }, executor);
                futures.add(future);
            }
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        result.put("totalItems", processedItems.size());
        result.put("chunkSize", chunkSize);
        result.put("totalChunks", chunks.size());
        result.put("successCount", successCount.get());
        result.put("failureCount", failureCount.get());
        LOGGER.info("Batch task processing completed: {}", (Object)result);
        return result;
    }

    public JSONObject process(List<T> items, Consumer<T> taskHandler) {
        return this.process(items, TaskType.IO_INTENSIVE, taskHandler, null, null, null);
    }

    private List<List<T>> splitList(List<T> list, int chunkSize) {
        ArrayList<List<T>> chunks = new ArrayList<List<T>>();
        int length = list.size();
        for (int i = 0; i < length; i += chunkSize) {
            int end = Math.min(i + chunkSize, length);
            chunks.add(list.subList(i, end));
        }
        return chunks;
    }

    public static enum TaskType {
        IO_INTENSIVE,
        CPU_INTENSIVE;

    }
}

