/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core;

import com.af.v4.system.common.plugins.http.config.CloseHttpLogHandler;
import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class HttpConnectionPoolUtil
extends BaseHttpPoolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnectionPoolUtil.class);
    private static final Object SYNC_LOCK = new Object();
    private static volatile CloseableHttpClient httpClient;

    public static CloseableHttpClient getHttpClient(TlsSocketStrategy sslSocketFactory) {
        return HttpConnectionPoolUtil.createHttpClient(sslSocketFactory);
    }

    private static CloseableHttpClient createHttpClient() {
        return HttpConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpClient createHttpClient(TlsSocketStrategy sslSocketFactory) {
        HttpClientConfig config = new HttpClientConfig.Builder().build();
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = new DefaultClientTlsStrategy(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        Registry registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager manager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)registry.lookup("https")).build();
        manager.setMaxTotal(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        manager.setDefaultMaxPerRoute(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).build();
        manager.setDefaultConnectionConfig(connectionConfig);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).setResponseTimeout(Timeout.ofSeconds((long)config.getSocketTimeout().intValue())).build();
        ConnectionKeepAliveStrategy myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = (HeaderElement)it.next();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return TimeValue.ofSeconds((long)(Long.parseLong(value) * 1000L));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return TimeValue.ofSeconds((long)5000L);
        };
        return HttpClients.custom().setKeepAliveStrategy(myStrategy).setConnectionManagerShared(true).setConnectionManager((HttpClientConnectionManager)manager).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(0, TimeValue.ofSeconds((long)1L))).evictExpiredConnections().evictIdleConnections(TimeValue.ofMilliseconds((long)HttpClientConfig.HTTP_IDEL_TIME_OUT.intValue())).setDefaultRequestConfig(requestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpConnectionPoolUtil.createHttpClient();
                }
            }
        }
        return httpClient;
    }

    public static String request(String value, String headersStr, HttpClientConfig config, Boolean isStandardResponse, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, isStandardResponse, null);
    }

    public static String request(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.request(value, headersStr, config, false, base);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, Boolean isStandardResponse, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, base, isStandardResponse, null);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, false, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, Boolean isStandardResponse, CloseableHttpClient httpClient) {
        String url = base.getScheme() + "://" + String.valueOf(base.getAuthority()) + base.getPath();
        if (httpClient == null) {
            httpClient = HttpConnectionPoolUtil.getHttpClient();
        }
        HttpConnectionPoolUtil.setRequestConfig(config, base);
        HttpConnectionPoolUtil.setHeaders((HttpRequest)base, headersStr);
        if (base.getEntity() == null) {
            HttpConnectionPoolUtil.setBody((HttpRequest)base, value);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        AtomicReference<String> result = new AtomicReference<String>();
        try {
            httpClient.execute((ClassicHttpRequest)base, (HttpContext)HttpClientContext.create(), response -> {
                stopWatch.stop();
                HttpConnectionPoolUtil.logExecutionTime(stopWatch);
                String body = HttpConnectionPoolUtil.getResponseData((HttpResponse)response);
                if (isStandardResponse.booleanValue()) {
                    Header[] headerArray;
                    JSONObject headerObject = new JSONObject();
                    for (Header header : headerArray = response.getHeaders()) {
                        headerObject.put(header.getName(), (Object)header.getValue());
                    }
                    result.set(new JSONObject().put("body", (Object)body).put("header", (Object)headerObject).toString());
                } else {
                    result.set(body);
                }
                return (String)result.get();
            });
        }
        catch (IOException e) {
            try {
                int code = e instanceof HttpHostConnectException | e instanceof ConnectTimeoutException ? 504 : 503;
                JSONObject errorResult = new JSONObject();
                errorResult.put("hasError", true);
                errorResult.put("code", code);
                errorResult.put("msg", (Object)e.getMessage());
                result.set(errorResult.toString());
            }
            catch (Throwable throwable) {
                boolean disableLogPrint = CloseHttpLogHandler.getDisableLogPrintValue();
                if (!disableLogPrint) {
                    LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{url, headersStr, value, result});
                }
                throw throwable;
            }
            boolean disableLogPrint = CloseHttpLogHandler.getDisableLogPrintValue();
            if (!disableLogPrint) {
                LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{url, headersStr, value, result});
            }
        }
        boolean disableLogPrint = CloseHttpLogHandler.getDisableLogPrintValue();
        if (!disableLogPrint) {
            LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{url, headersStr, value, result});
        }
        return (String)result.get();
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, Boolean isStandardResponse, CloseableHttpClient httpClient) {
        HttpConnectionPoolUtil.setUrlEncodedBody((ClassicHttpRequest)base, value);
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, isStandardResponse, httpClient);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, CloseableHttpClient httpClient) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, base, false, httpClient);
    }
}

