/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.wechat;

import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.wechat.WechatApi;
import com.af.v4.system.common.redis.RedisService;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WechatApiUtils {
    public static final Integer ERROR_AUTH_CODE = 40001;
    static final Logger LOGGER = LoggerFactory.getLogger(WechatApiUtils.class);
    private static final String WECHAT_API_TOKEN_CACHE_KEY = "wechatApiToken@";
    private final RedisService redisService;

    public WechatApiUtils(RedisService redisService) {
        this.redisService = redisService;
    }

    private static String getWechatApiTokenRedisKey(String appid) {
        return WECHAT_API_TOKEN_CACHE_KEY + appid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthToken(String appid, String secret, Boolean forceRefresh) {
        String key = WechatApiUtils.getWechatApiTokenRedisKey(appid);
        String token = (String)this.redisService.get(key);
        if (token != null) {
            LOGGER.info("{}:\u83b7\u53d6\u73b0\u6709token", (Object)appid);
            return token;
        }
        Class<WechatApiUtils> clazz = WechatApiUtils.class;
        synchronized (WechatApiUtils.class) {
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return (String)this.redisService.syncLock(key, () -> {
                String newToken = (String)this.redisService.get(key);
                if (newToken != null) {
                    LOGGER.info("{}:\u83b7\u53d6\u73b0\u6709token", (Object)appid);
                    return newToken;
                }
                if (forceRefresh.booleanValue()) {
                    LOGGER.info("\u5fae\u4fe1\uff1a{}:\u8fdb\u884c\u5f3a\u5236\u5237\u65b0\u9274\u6743\u64cd\u4f5c", (Object)appid);
                } else {
                    LOGGER.info("\u5fae\u4fe1\uff1a{}:\u8fdb\u884c\u9274\u6743\u64cd\u4f5c", (Object)appid);
                }
                JSONObject content = new JSONObject();
                content.put("grant_type", (Object)"client_credential");
                content.put("appid", (Object)appid);
                content.put("secret", (Object)secret);
                content.put("force_refresh", (Object)forceRefresh);
                JSONObject result = new JSONObject(RestTools.post(WechatApi.getAuthUrl(), content));
                if (result.has("errcode")) {
                    throw new RuntimeException(result.toString());
                }
                String accessToken = result.getString("access_token");
                int expiresIn = result.getInt("expires_in");
                this.redisService.set(key, (Object)accessToken, (Object)(expiresIn - 180));
                return accessToken;
            });
        }
    }

    public String getAuthToken(String appid, String secret) {
        return this.getAuthToken(appid, secret, false);
    }

    private List<String> getAllOpenId(List<String> openIdArray, String accessToken, String nextOpenIds) {
        JSONObject result;
        String url = WechatApi.getGetOpenidUrl() + "?access_token=" + accessToken;
        if (nextOpenIds != null) {
            url = url + "&next_openid=" + nextOpenIds;
        }
        if ((result = new JSONObject(RestTools.get(url))).has("data")) {
            String nextOpenId = result.getString("next_openid");
            JSONObject data = result.getJSONObject("data");
            int count = result.getInt("count");
            JSONArray openIds = data.getJSONArray("openid");
            for (Object openId : openIds) {
                openIdArray.add((String)openId);
            }
            if (count < 10000) {
                return openIdArray;
            }
            return this.getAllOpenId(openIdArray, accessToken, nextOpenId);
        }
        throw new RuntimeException("\u83b7\u53d6\u6240\u6709\u7528\u6237\u7684OpenId\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + String.valueOf(result));
    }

    public List<String> getAllOpenId(JSONObject authInfo) {
        String accessToken = this.getAuthToken(authInfo.getString("appid"), authInfo.getString("secret"));
        ArrayList<String> allOpenIds = new ArrayList<String>(10000);
        return this.getAllOpenId(allOpenIds, accessToken, null);
    }

    public JSONObject sendTemplateMessage(JSONObject authInfo, String openId, String templateId, String url, String miniprogram, String appid, String pagepath, JSONObject data, String orgName) {
        JSONObject body = new JSONObject();
        body.put("touser", (Object)openId);
        body.put("template_id", (Object)templateId);
        body.put("url", (Object)url);
        body.put("miniprogram", (Object)miniprogram);
        body.put("appid", (Object)appid);
        body.put("pagepath", (Object)pagepath);
        body.put("data", (Object)data);
        body.put("orgname", (Object)orgName);
        String accessToken = this.getAuthToken(authInfo.getString("appid"), authInfo.getString("secret"));
        String requestUrl = WechatApi.getSendTemplateMessageUrl() + "?access_token=" + accessToken;
        return new JSONObject(RestTools.post(requestUrl, body));
    }

    public JSONObject clearQuota(JSONObject authInfo) {
        JSONObject body = new JSONObject();
        body.put("appid", (Object)authInfo.getString("appid"));
        String accessToken = this.getAuthToken(authInfo.getString("appid"), authInfo.getString("secret"));
        String requestUrl = WechatApi.getClearQuotaUrl() + "?access_token=" + accessToken;
        return new JSONObject(RestTools.post(requestUrl, body));
    }
}

