/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.other;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;

public class Base64Tools {
    private static final int CACHE_SIZE = 1024;

    public static String decode(String base64) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64);
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }

    public static String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBuffer(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static byte[] encodeBuffer(byte[] bytes) {
        return Base64.getEncoder().encode(bytes);
    }

    public static String encodeFile(String filePath) throws Exception {
        byte[] bytes = Base64Tools.fileToByte(filePath);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] fileToByte(String filePath) throws Exception {
        return Files.readAllBytes(Paths.get(filePath, new String[0]));
    }

    public static void byteArrayToFile(byte[] bytes, String filePath) throws Exception {
        Files.write(Paths.get(filePath, new String[0]), bytes, new OpenOption[0]);
    }

    public static String decodeData(String inputData) {
        return Base64Tools.decode(inputData);
    }

    public static String encodeData(String inputData) {
        byte[] decodedBytes = Base64.getEncoder().encode(inputData.getBytes());
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }
}

