package com.af.v4.system.common.plugins.http.core.response;

import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 空异步响应实现
 *
 * @author Mr.river
 * @apiNote 成功时无处理，失败时打印日志
 */
public class EmptyAsyncResponse implements FutureCallback<SimpleHttpResponse> {

    private static final Logger logger = LoggerFactory.getLogger(EmptyAsyncResponse.class);

    @Override
    public void completed(SimpleHttpResponse response) {
    }

    @Override
    public void failed(Exception ex) {
        logger.error("异步请求时发生异常：", ex);
    }

    @Override
    public void cancelled() {

    }
}
