package com.af.v4.system.common.plugins.http.config;

import java.io.Closeable;
import java.util.Objects;

/**
 * 临时关闭HTTP请求日志
 */
public class CloseHttpLogHandler implements Closeable {
    /**
     * 禁用日志输出
     */
    private static final ThreadLocal<Boolean> disableLogPrintThreadLocal = new ThreadLocal<>();


    private CloseHttpLogHandler() {
    }

    public static boolean getDisableLogPrintValue() {
        Boolean yn = disableLogPrintThreadLocal.get();
        return Objects.requireNonNullElse(yn, false);
    }

    public static CloseHttpLogHandler build() {
        return new CloseHttpLogHandler();
    }

    public void apply() {
        disableLogPrintThreadLocal.set(true);
    }

    @Override
    public void close() {
        disableLogPrintThreadLocal.remove();
    }
}
