package com.af.v4.system.common.plugins.http;

import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.core.HttpAsyncConnectionPoolUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.json.JSONObject;

/**
 * HTTP异步请求工具类
 *
 * @author Mr.river
 */
public class RestAsyncTools {

    /**
     * 发送通用异步Http请求
     *
     * @param value          请求参数
     * @param headers        请求头
     * @param base           请求类型
     * @param config         HttpClient配置文件
     * @param futureCallback 异步回调处理函数
     */
    public static void request(String value, String headers, HttpClientConfig config, SimpleHttpRequest base, FutureCallback<SimpleHttpResponse> futureCallback) {
        JSONObject headerJson = BaseHttpPoolUtil.buildHeader(headers);
        HttpAsyncConnectionPoolUtil.request(value, headerJson.toString(), config, base, null, futureCallback);
    }

    /**
     * 发送post请求
     *
     * @param path           请求路径
     * @param value          请求体
     * @param headers        请求头
     * @param futureCallback 异步回调接口
     */
    public static void post(String path, String value, String headers, FutureCallback<SimpleHttpResponse> futureCallback) {
        request(value, headers, null, SimpleRequestBuilder.post(path).build(), futureCallback);
    }

    public static void post(String path, JSONObject value) {
        post(path, value == null ? null : value.toString(), null, null);
    }

    /**
     * 发送get请求
     *
     * @param path           请求路径
     * @param headers        请求头
     * @param futureCallback 异步回调接口
     */
    public static void get(String path, String headers, FutureCallback<SimpleHttpResponse> futureCallback) {
        request(null, headers, null, SimpleRequestBuilder.get(path).build(), futureCallback);
    }

    public static void get(String path) {
        get(path, null, null);
    }

    /**
     * 发送put请求
     *
     * @param path           请求路径
     * @param value          请求参数
     * @param headers        请求头
     * @param futureCallback 异步回调接口
     */
    public static void put(String path, String value, String headers, FutureCallback<SimpleHttpResponse> futureCallback) {
        request(value, headers, null, SimpleRequestBuilder.put(path).build(), futureCallback);
    }

    public static void put(String path, JSONObject value) {
        put(path, value == null ? null : value.toString(), null, null);
    }

    /**
     * 发送delete请求
     *
     * @param path           请求路径
     * @param value          请求参数
     * @param headers        请求头
     * @param futureCallback 异步回调接口
     */
    public static void delete(String path, String value, String headers, FutureCallback<SimpleHttpResponse> futureCallback) {
        request(value, headers, null, SimpleRequestBuilder.delete(path).build(), futureCallback);
    }

    public static void delete(String path, JSONObject value) {
        delete(path, value == null ? null : value.toString(), null, null);
    }
}
