package com.af.v4.system.common.plugins.core;

import cn.hutool.crypto.SecureUtil;

import java.nio.charset.StandardCharsets;

/**
 * 加解密工具类
 *
 * @author Mr.river
 */
public class SecureTools {
    /**
     * AES加密
     *
     * @param plainText 待加密内容
     * @param key       密钥
     * @return 加密后的字符串
     */
    public static String AESEncrypt(final String plainText, final String key) {
        return SecureUtil.aes(ConvertTools.base64Decode(key.getBytes(StandardCharsets.UTF_8))).encryptBase64(plainText);
    }

    /**
     * AES解密
     *
     * @param cipherText 待解密内容
     * @param key        密钥
     * @return 解密后的字符串
     */
    public static String AESDecrypt(final String cipherText, final String key) {
        return SecureUtil.aes(ConvertTools.base64Decode(key.getBytes(StandardCharsets.UTF_8))).decryptStr(cipherText);
    }
}
