package com.af.v4.system.common.plugins.other;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Classname ReportTools
 * @Description TODO
 * @Date 2024/5/9 下午1:51
 * @Created by 张振宇
 */
public class ReportTools {

    /**
     * @param start 起始序号
     * @param count 产生数量
     * @return List<String>
     * @author zhaotong 本函数主要为逻辑提供连续的5位数，用来给数据库某字段进行标记
     */
    public static List<String> getNumberMark(String start, String count) {
        int s = Integer.parseInt(start);
        int c = Integer.parseInt(count);
        return getNumberMark(s, c);
    }

    /**
     * @param start 起始序号
     * @param count 产生数量
     * @return List<String>
     * @author zhaotong 本函数主要为逻辑提供连续的5位数，用来给数据库某字段进行标记(参数均为int)
     */
    public static List<String> getNumberMark(int start, int count) {
        List<String> list = new ArrayList<String>();
        for (int i = 1; i <= count; i++) {
            list.add(getNumberFormat(start) + i);
        }

        return list;
    }

    public static String getNumberFormat(int num) {
        return String.format("%05d", num);
    }

    /**
     * 数字千分号转换
     *
     * @param num 转换数字
     */
    public static String seg(Object num) {
        if (num == null) {
            return "0";
        }

        String investPrice = NumberFormat.getCurrencyInstance().format(num);

        return investPrice.replace("￥", "");
    }

    /**
     * 数字为0转换为空字符串
     *
     * @param num 转换数字
     */
    public static String isnull(Object num) {
        if (num == null) {
            return " ";
        }
        try {
            if (Double.parseDouble(num.toString()) == 0) {
                return " ";
            }
        } catch (Exception e) {
            return num.toString();
        }
        return num.toString();
    }

    /**
     * 判断数组是否有值，无值返回空串，否则取key
     *
     * @param num 转换数字
     */
    public static String getValue(JSONArray array, int num, String key) {
        if (array == null || array.length() == 0) {
            return "";
        }
        JSONObject json = new JSONObject(array.get(num).toString());
        String result = json.get(key) == null ? "" : json.get(key).toString();

        return result;
    }

    /**
     * 将指定字符串转换为空字符串
     *
     * @param num 转换数字
     */
    public static String isnull(Object num, String flag) {
        if (num == null) {
            return " ";
        }
        if (flag == null || flag.trim().isEmpty()) {
            return num.toString();
        }
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher isNum1 = pattern.matcher(num.toString());
        Matcher isNum2 = pattern.matcher(flag);
        if (isNum1.matches() && isNum2.matches() && Double.parseDouble(flag) == Double.parseDouble(num.toString())) {
            return " ";
        }
        if (!isNum1.matches() && !isNum2.matches() && num.toString().equals(flag)) {
            return " ";
        }
        return num.toString();
    }

    public static Double isNum(Object num, String flag) {
//		flag==‘null’ 返回 null
        if (num == null || num.toString().trim().isEmpty()) {
            if (flag == null || flag.equals("null")) {
                return null;
            }
            return 0.00;
        }
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher isNum = pattern.matcher(num.toString());
        if (isNum.matches()) {
            return Double.parseDouble(num.toString());
        } else {
            if (flag == null || flag.equals("null")) {
                return null;
            }
            return 0.00;
        }
    }

    /**
     * 数字分节
     *
     * @param num 转换数字
     */
    public static String getNumFor(int x, Object num) {
        if (num == null) {
            return "0";
        }
        DecimalFormat df1 = (DecimalFormat) DecimalFormat.getInstance();
        df1.setGroupingSize(x);
        return df1.format(Long.valueOf(num.toString()));
    }

    /**
     * 获取两数的百分比
     *
     * @param a
     * @param b
     * @return
     */
    public static String getPercent(BigDecimal a, BigDecimal b) {
        BigDecimal c = new BigDecimal(0);
        if (a.compareTo(c) == 0 || b.compareTo(c) == 0) {
            return "0.00%";
        } else {
            BigDecimal d = a.divide(b, 2, BigDecimal.ROUND_HALF_UP);
            String s = d.toString();
            String perc = s.substring(2) + '%';
            return perc;
        }
    }

    /**
     * 格式化 0
     *
     * @param s
     * @param inx
     * @return
     */
    public static String numFormat(Object s, int inx) {
        StringBuffer m = new StringBuffer("0");
        for (int i = 0; i < inx; i++) {
            if (i == 0) m.append(".");
            m.append("0");
        }
        if (s == null) return m.toString();
        if (s instanceof BigDecimal) {
            int flag = ((BigDecimal) s).compareTo(BigDecimal.ZERO);
            if (flag == 0) return m.toString();
            return s.toString();
        } else {
            Double d = Double.parseDouble(s.toString());
            if (d == 0) return m.toString();
            return d.toString();
        }
    }

    public static String getPercent(int a, int b) {
        if (a == 0 || b == 0) {
            return "0.00%";
        } else {
            float num = (float) a / b;
            DecimalFormat df = new DecimalFormat("0.00");
            String s = df.format(num);
            String ss = s.substring(2) + '%';
            return ss;
        }
    }

    public String getNow() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(new Date());
    }

    // 把系统时间推迟或提前数分钟
    public String getNextMinute(int count) {
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MINUTE, count);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(c.getTime());
    }

    // 把系统时间推迟或提前数天
    public String getNextDay(int count) {
        Calendar c = Calendar.getInstance();
        c.add(Calendar.DAY_OF_MONTH, count);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(c.getTime());
    }

    // 计算开始时间和结束时间方法
    public static JSONObject computeDate(int stairmonths) {
        String startDate;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String endDate = formatter.format(new Date());

        Calendar cal = Calendar.getInstance();
        int year = Integer.parseInt(endDate.substring(0, 4));
        int month = Integer.parseInt(endDate.substring(5, 7));
        int day = Integer.parseInt(endDate.substring(8, 10));
        cal.set(year, month - 1, day);

        // 计算当前月在哪个阶梯区间
        // Calendar cal = Calendar.getInstance();
        // int thismonth = cal.get(Calendar.MONTH) + 1;
        int thismonth = cal.get(Calendar.MONTH);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (stairmonths == 1) {
            cal.set(Calendar.DAY_OF_MONTH, 1);
            startDate = format.format(cal.getTime());
            cal.set(Calendar.DAY_OF_MONTH,
                    cal.getActualMaximum(Calendar.DAY_OF_MONTH));
            endDate = format.format(cal.getTime());
        } else if (stairmonths == 0) {
            startDate = "";
            endDate = "";
        } else {
            /*
             * 阶梯起始月数计算起始月 = 当前月/阶梯月数*阶梯月数+1结束月 = 当前月/阶梯月数*阶梯月数+阶梯月数注：该运算
             * 当前月是12月时则需要剪1 上面已经算出阶梯月数为1个月时的金额一下运算阶梯月数至少为两个月 所以对算区间没有影响
             */
            if (thismonth == 12) {
                thismonth = 11;
            }
            // 计算起始月
            int star = Math.round(thismonth / stairmonths) * stairmonths + 1;
            // 计算结束月
            int end = Math.round(thismonth / stairmonths) * stairmonths
                    + stairmonths;
            // 获得起始日期和结束日期
            cal.set(Calendar.MONTH, star - 1);
            cal.set(Calendar.DAY_OF_MONTH, 1);
            startDate = format.format(cal.getTime());
            cal.set(Calendar.MONTH, end - 1);
            cal.set(Calendar.DAY_OF_MONTH,
                    cal.getActualMaximum(Calendar.DAY_OF_MONTH));
            endDate = format.format(cal.getTime());
        }
        JSONObject jo = new JSONObject();
        jo.put("startDate", startDate);
        jo.put("endDate", endDate);

        return jo;
    }

    public String format(String dt, String pattern) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dt);
            return new SimpleDateFormat(pattern).format(date);
        } catch (Exception e) {
            return null;
        }
    }
}
