/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.charts;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChartsTools {
    private static final String DEFAULT_SERIES = "\u8ba1\u6570";
    private static final String SERIES_DELIMITER = "-";
    private static final String KEY_DELIMITER = "_";
    private static final int DEFAULT_PRECISION = 2;
    private static final Set<String> VALID_MOLDS = new HashSet<String>(Arrays.asList("sum", "max", "min", "avg", "count"));

    private void validateConfig(JSONObject chartConfig) {
        if (!chartConfig.has("xField")) {
            throw new IllegalArgumentException("\u5fc5\u987b\u914d\u7f6e xField");
        }
        if ("sum".equals(chartConfig.getString("yFieldType")) && !chartConfig.has("yField")) {
            throw new IllegalArgumentException("\u5fc5\u987b\u914d\u7f6e yField");
        }
        String yFieldType = chartConfig.optString("yFieldType", "sum").toLowerCase();
        if (!VALID_MOLDS.contains(yFieldType)) {
            throw new IllegalArgumentException("yFieldType \u5fc5\u987b\u662f sum, max, min, avg \u6216 count");
        }
    }

    public JSONArray processChartData(JSONArray data, JSONObject chartConfig, ChartType chartType) {
        this.validateConfig(chartConfig);
        ChartConfig config = ChartConfig.fromJSON(chartConfig);
        return this.processAxisChartData(data, config);
    }

    private double formatNumber(double value, int precision) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(precision, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    private JSONArray processAxisChartData(JSONArray data, ChartConfig config) {
        DataAggregator aggregator = new DataAggregator();
        boolean isCount = "count".equals(config.getYFieldType());
        data.forEach(obj -> {
            JSONObject item = (JSONObject)obj;
            Optional.ofNullable(item.optString(config.getXField())).filter(x -> !x.trim().isEmpty()).ifPresent(xValue -> {
                String groupValue = config.getGroupField() != null ? item.optString(config.getGroupField()) : null;
                aggregator.collectValue(xValue.trim(), groupValue);
            });
        });
        if (isCount) {
            this.processCountType(data, config, aggregator);
        } else {
            this.processSumType(data, config, aggregator);
        }
        this.fillMissingValues(config, aggregator);
        return aggregator.buildResult(config.getXField());
    }

    private void processCountType(JSONArray data, ChartConfig config, DataAggregator aggregator) {
        for (int j = 0; j < data.length(); ++j) {
            String xValue;
            JSONObject item = data.getJSONObject(j);
            if (item.isNull(config.getXField()) || (xValue = item.optString(config.getXField(), "").trim()).isEmpty()) continue;
            if (config.getGroupField() != null) {
                String groupValue = item.isNull(config.getGroupField()) ? "" : item.optString(config.getGroupField());
                Object seriesName = groupValue.isEmpty() ? DEFAULT_SERIES : groupValue + "-\u8ba1\u6570";
                String key = xValue + KEY_DELIMITER + (String)seriesName;
                aggregator.addValue(key, 1.0, (String)seriesName, config.getPrecision());
                continue;
            }
            String key = xValue + "_\u8ba1\u6570";
            aggregator.addValue(key, 1.0, DEFAULT_SERIES, config.getPrecision());
        }
    }

    private void processSumType(JSONArray data, ChartConfig config, DataAggregator aggregator) {
        for (int j = 0; j < data.length(); ++j) {
            String xValue;
            JSONObject item = data.getJSONObject(j);
            if (item.isNull(config.getXField()) || (xValue = item.optString(config.getXField(), "").trim()).isEmpty()) continue;
            for (int k = 0; k < config.getYFields().length(); ++k) {
                JSONObject yField = config.getYFields().getJSONObject(k);
                String field = yField.getString("field");
                String label = yField.optString("label", field);
                String mold = yField.optString("mold", "sum").toLowerCase();
                if (!VALID_MOLDS.contains(mold)) continue;
                if (config.getGroupField() != null) {
                    String groupValue = item.isNull(config.getGroupField()) ? "" : item.optString(config.getGroupField());
                    String seriesName = groupValue.isEmpty() ? label : groupValue + SERIES_DELIMITER + label;
                    String key = xValue + KEY_DELIMITER + seriesName;
                    this.processValue(item, field, mold, config.getPrecision(), aggregator, key, seriesName);
                    continue;
                }
                String key = xValue + KEY_DELIMITER + label;
                this.processValue(item, field, mold, config.getPrecision(), aggregator, key, label);
            }
        }
    }

    private void fillMissingValues(ChartConfig config, DataAggregator aggregator) {
        block6: {
            block5: {
                if (config.getGroupField() == null || !"count".equals(config.getYFieldType())) break block5;
                for (String xValue : aggregator.xValues) {
                    for (String groupValue : aggregator.groupValues) {
                        Object seriesName = groupValue.isEmpty() ? DEFAULT_SERIES : groupValue + "-\u8ba1\u6570";
                        String key = xValue + KEY_DELIMITER + (String)seriesName;
                        if (aggregator.valueMap.containsKey(key)) continue;
                        aggregator.addValue(key, 0.0, (String)seriesName, config.getPrecision());
                    }
                }
                break block6;
            }
            if (config.getGroupField() == null) break block6;
            for (String xValue : aggregator.xValues) {
                for (String groupValue : aggregator.groupValues) {
                    for (int k = 0; k < config.getYFields().length(); ++k) {
                        JSONObject yField = config.getYFields().getJSONObject(k);
                        String label = yField.optString("label", yField.getString("field"));
                        Object seriesName = groupValue.isEmpty() ? label : groupValue + SERIES_DELIMITER + label;
                        String key = xValue + KEY_DELIMITER + (String)seriesName;
                        if (aggregator.valueMap.containsKey(key)) continue;
                        aggregator.addValue(key, 0.0, (String)seriesName, config.getPrecision());
                    }
                }
            }
        }
    }

    private void processValue(JSONObject item, String field, String mold, int precision, DataAggregator aggregator, String key, String seriesName) {
        try {
            double value;
            if (!(item.isNull(field) || Double.isNaN(value = item.getDouble(field)) || Double.isInfinite(value))) {
                value = this.formatNumber(value, precision);
                switch (mold.toLowerCase()) {
                    case "sum": {
                        aggregator.addValue(key, value, seriesName, precision);
                        break;
                    }
                    case "max": {
                        aggregator.updateMax(key, value, seriesName);
                        break;
                    }
                    case "min": {
                        aggregator.updateMin(key, value, seriesName);
                        break;
                    }
                    case "avg": {
                        aggregator.addToAverage(key, value, seriesName);
                        break;
                    }
                    default: {
                        aggregator.addValue(key, 1.0, seriesName, precision);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONArray mergeGroupData(JSONArray totalData, JSONArray newData, JSONObject chartConfig) {
        String key;
        String xValue;
        JSONObject item;
        int i;
        JSONArray processedNewData = this.processChartData(newData, chartConfig, ChartType.LINE);
        if (totalData == null || totalData.isEmpty()) {
            return processedNewData;
        }
        String xField = chartConfig.getString("xField");
        JSONArray yFields = chartConfig.getJSONArray("yField");
        String groupField = chartConfig.optString("groupField", null);
        LinkedHashMap<String, JSONObject> mergedMap = new LinkedHashMap<String, JSONObject>();
        for (i = 0; i < totalData.length(); ++i) {
            item = totalData.getJSONObject(i);
            if (item.isNull(xField) || (xValue = item.optString(xField, "")).isEmpty()) continue;
            key = groupField != null ? (item.isNull(groupField) ? "" : item.optString(groupField)) + KEY_DELIMITER + xValue : xValue;
            mergedMap.put(key, new JSONObject(item.toString()));
        }
        for (i = 0; i < processedNewData.length(); ++i) {
            item = processedNewData.getJSONObject(i);
            if (item.isNull(xField) || (xValue = item.optString(xField, "")).isEmpty()) continue;
            Object object = groupField != null ? (item.isNull(groupField) ? "" : item.optString(groupField)) + KEY_DELIMITER + xValue : (key = xValue);
            if (mergedMap.containsKey(key)) {
                JSONObject existing = (JSONObject)mergedMap.get(key);
                for (int j = 0; j < yFields.length(); ++j) {
                    JSONObject yField = yFields.getJSONObject(j);
                    String field = yField.getString("field");
                    double sum = existing.getDouble(field) + item.getDouble(field);
                    existing.put(field, this.formatNumber(sum, chartConfig.optInt("precision", 2)));
                }
                continue;
            }
            mergedMap.put(key, new JSONObject(item.toString()));
        }
        JSONArray result = new JSONArray();
        for (JSONObject value : mergedMap.values()) {
            result.put((Object)value);
        }
        return result;
    }

    public static class ChartConfig {
        private final String xField;
        private final JSONArray yFields;
        private final String groupField;
        private final String yFieldType;
        private final int precision;

        private ChartConfig(Builder builder) {
            this.xField = builder.xField;
            this.yFields = builder.yFields;
            this.groupField = builder.groupField;
            this.yFieldType = builder.yFieldType;
            this.precision = builder.precision;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ChartConfig fromJSON(JSONObject config) {
            return ChartConfig.builder().xField(config.getString("xField")).yFields(config.optJSONArray("yField")).groupField(config.optString("groupField")).yFieldType(config.optString("yFieldType", "sum").toLowerCase()).precision(config.optInt("precision", 2)).build();
        }

        public String getXField() {
            return this.xField;
        }

        public JSONArray getYFields() {
            return this.yFields;
        }

        public String getGroupField() {
            return this.groupField;
        }

        public String getYFieldType() {
            return this.yFieldType;
        }

        public int getPrecision() {
            return this.precision;
        }

        public static class Builder {
            private String xField;
            private JSONArray yFields;
            private String groupField;
            private String yFieldType;
            private int precision;

            public Builder xField(String xField) {
                this.xField = xField;
                return this;
            }

            public Builder yFields(JSONArray yFields) {
                this.yFields = yFields;
                return this;
            }

            public Builder groupField(String groupField) {
                this.groupField = groupField;
                return this;
            }

            public Builder yFieldType(String yFieldType) {
                this.yFieldType = yFieldType;
                return this;
            }

            public Builder precision(int precision) {
                this.precision = precision;
                return this;
            }

            public ChartConfig build() {
                return new ChartConfig(this);
            }
        }
    }

    private class DataAggregator {
        private final Set<String> xValues = new LinkedHashSet<String>();
        private final Set<String> groupValues = new LinkedHashSet<String>();
        private final Map<String, Double> valueMap = new LinkedHashMap<String, Double>();
        private final Map<String, String> seriesMap = new LinkedHashMap<String, String>();
        private final Map<String, AggregateData> aggregateData = new LinkedHashMap<String, AggregateData>();

        private DataAggregator() {
        }

        public void collectValue(String xValue, String groupValue) {
            this.xValues.add(xValue);
            if (groupValue != null) {
                this.groupValues.add(groupValue);
            }
        }

        public void addValue(String key, double value, String seriesName, int precision) {
            this.valueMap.merge(key, value, (a, b) -> ChartsTools.this.formatNumber(a + b, precision));
            this.seriesMap.put(key, seriesName);
        }

        public void updateMax(String key, double value, String seriesName) {
            this.aggregateData.compute(key, (k, v) -> {
                if (v == null) {
                    return new AggregateData(value, seriesName);
                }
                v.value = Math.max(v.value, value);
                return v;
            });
        }

        public void updateMin(String key, double value, String seriesName) {
            this.aggregateData.compute(key, (k, v) -> {
                if (v == null) {
                    return new AggregateData(value, seriesName);
                }
                v.value = Math.min(v.value, value);
                return v;
            });
        }

        public void addToAverage(String key, double value, String seriesName) {
            this.aggregateData.compute(key, (k, v) -> {
                if (v == null) {
                    return new AggregateData(value, seriesName);
                }
                v.value += value;
                ++v.count;
                return v;
            });
        }

        public JSONArray buildResult(String xField) {
            JSONArray result = new JSONArray();
            this.aggregateData.forEach((key, data) -> {
                String[] parts = key.split(ChartsTools.KEY_DELIMITER);
                JSONObject point = new JSONObject().put(xField, (Object)parts[0]).put("value", data.value / (double)(data.count > 0L ? data.count : 1L)).put("series", (Object)data.seriesName);
                result.put((Object)point);
            });
            this.valueMap.forEach((key, value) -> {
                if (!this.aggregateData.containsKey(key)) {
                    String[] parts = key.split(ChartsTools.KEY_DELIMITER);
                    JSONObject point = new JSONObject().put(xField, (Object)parts[0]).put("value", value).put("series", (Object)this.seriesMap.get(key));
                    result.put((Object)point);
                }
            });
            return result;
        }

        private static class AggregateData {
            final String seriesName;
            double value;
            long count;

            AggregateData(double value, String seriesName) {
                this.value = value;
                this.count = 1L;
                this.seriesName = seriesName;
            }
        }
    }

    public static enum ChartType {
        LINE,
        BAR,
        PIE;

    }
}

