package com.af.v4.system.common.plugins.http.core.response;

import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

import java.io.IOException;


/**
 * 默认异步响应实现
 *
 * @author Mr.river
 * @apiNote 实现了对响应结果的打印
 */
public class DefaultAsyncResponse implements AsyncResponse {

    protected static final Logger logger = LoggerFactory.getLogger(DefaultAsyncResponse.class);

    protected final StopWatch stopWatch = new StopWatch();

    private String url;

    private String headers;

    private String body;

    private Boolean isStandardResponse;

    @Override
    public void setContext(String url, String headers, String body, Boolean isStandardResponse) {
        this.url = url;
        this.headers = headers;
        this.body = body;
        if (!stopWatch.isRunning()) {
            stopWatch.start();
        }
        this.isStandardResponse = isStandardResponse;
    }

    @Override
    public void completed(SimpleHttpResponse response) {
        getAndPrintResponse(response);
    }

    @Override
    public void failed(Exception ex) {
        String responseData;
        if (ex instanceof IOException ioException) {
            responseData = BaseHttpPoolUtil.buildErrorResult(ioException);
        } else {
            // 非 IO 异常直接输出异常消息，保持原始异常栈
            responseData = "''";
            logger.error("异步请求时发生异常：", ex);
        }
        BaseHttpPoolUtil.stop(stopWatch);
        BaseHttpPoolUtil.printLog(logger, "async", stopWatch, url, headers, body, responseData);
    }

    @Override
    public void cancelled() {
        BaseHttpPoolUtil.stop(stopWatch);
    }

    /**
     * 获取响应结果并打印日志
     */
    protected String getAndPrintResponse(HttpResponse response) {
        try {
            String responseData = BaseHttpPoolUtil.getResponseData(response, isStandardResponse);
            BaseHttpPoolUtil.stop(stopWatch);
            BaseHttpPoolUtil.printLog(logger, "async", stopWatch, url, headers, body, responseData);
            return responseData;
        } catch (Exception e) {
            this.failed(e);
            return null;
        }
    }
}
