/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import com.af.v4.system.common.plugins.core.PriceFormatTools;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import org.json.JSONArray;

public class ConvertTools {
    static final NumberFormat NF = NumberFormat.getInstance();

    public static String formatNumber(Object value) {
        return PriceFormatTools.formatNumberBase(value);
    }

    public static int stringToInt(String str) {
        return Convert.toInt((Object)str);
    }

    public static double stringToDouble(String str) {
        return Convert.toDouble((Object)str);
    }

    public static BigDecimal stringToBigDecimal(String num) {
        return Convert.toBigDecimal((Object)num);
    }

    public static String bigDecimalToString(BigDecimal bigDecimal) {
        return Convert.toStr((Object)bigDecimal);
    }

    public static String byteArrayToString(byte[] bytes) throws UnsupportedEncodingException {
        return ConvertTools.byteArrayToCharsetString(bytes, "UTF-8");
    }

    public static String byteArrayToCharsetString(byte[] bytes, String charset) throws UnsupportedEncodingException {
        return new String(bytes, charset);
    }

    public static String base64Encode(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        return new String(encoder.encode(bytes), StandardCharsets.UTF_8);
    }

    public static byte[] base64Decode(byte[] bytes) {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(bytes);
    }

    public static String byteToHexStr(byte[] bytes) {
        return HexUtil.encodeHexStr((byte[])bytes);
    }

    public static byte[] hexStrToByte(String hexStr) {
        return HexUtil.decodeHex((String)hexStr);
    }

    public static int hexStrToInt(String hexStr) {
        return HexUtil.hexToInt((String)hexStr);
    }

    public static byte[] strToBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String bytesToStr(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String stringToCharset(String str, String oldCharset, String newCharset) throws UnsupportedEncodingException {
        if (null != str) {
            str = new String(str.getBytes(oldCharset), newCharset);
        }
        return str;
    }

    public static String hexStrToBinaryStr(String hexString) {
        StringBuilder bString = new StringBuilder();
        for (int i = 0; i < hexString.length(); ++i) {
            String tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hexString.substring(i, i + 1), 16));
            bString.append(tmp.substring(tmp.length() - 4));
        }
        if (bString.length() == 4) {
            bString = new StringBuilder("0000").append((CharSequence)bString);
        }
        bString.reverse();
        return bString.toString();
    }

    public static String binaryStrToHexStr(String bString) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < bString.length(); i += 4) {
            int iTmp = 0;
            for (int j = 0; j < 4; ++j) {
                iTmp += Integer.parseInt(bString.substring(i + j, i + j + 1)) << 4 - j - 1;
            }
            tmp.append(Integer.toHexString(iTmp));
        }
        return tmp.toString();
    }

    public static byte[] binaryStrToBinaryArray(String binaryString) {
        byte[] result = new byte[binaryString.length()];
        for (int i = 0; i < binaryString.length(); ++i) {
            result[i] = (byte)"0123456789ABCDEF".indexOf(binaryString.charAt(i));
        }
        return result;
    }

    public static int ceil(Object numObj) {
        BigDecimal b = new BigDecimal(numObj.toString());
        return b.setScale(0, RoundingMode.UP).intValue();
    }

    public static double ceil(Object numObj, Object scale) {
        BigDecimal b = new BigDecimal(numObj.toString());
        return b.setScale(Integer.parseInt(String.valueOf(scale)), RoundingMode.UP).doubleValue();
    }

    public static int floor(Object numObj) {
        BigDecimal b = new BigDecimal(numObj.toString());
        return b.setScale(0, RoundingMode.DOWN).intValue();
    }

    public static double floor(Object numObj, Object scale) {
        BigDecimal b = new BigDecimal(numObj.toString());
        return b.setScale(Integer.parseInt(String.valueOf(scale)), RoundingMode.DOWN).doubleValue();
    }

    public static int round(Object numObj) {
        BigDecimal b = new BigDecimal(numObj.toString());
        return b.setScale(0, RoundingMode.HALF_UP).intValue();
    }

    public static double round(Object numObj, Object scale) {
        BigDecimal b = new BigDecimal(numObj.toString());
        return b.setScale(Integer.parseInt(String.valueOf(scale)), RoundingMode.HALF_UP).doubleValue();
    }

    public static String replaceAll(String str) {
        return str.replace(" ", "");
    }

    public static JSONArray splitString(String str, String flag) {
        if ("yAxis".equals(flag)) {
            flag = "\\|";
        }
        return new JSONArray((Collection)StrUtil.split((CharSequence)str, (CharSequence)flag));
    }

    public static String scientificToNum(String scientificNum) {
        return NF.format(new BigDecimal(scientificNum));
    }

    public static byte[] copyBytes(byte[] sourceBytes, byte[] targetBytes, int beginIndex) {
        int sourceSize;
        if (targetBytes == null) {
            return sourceBytes;
        }
        int targetSize = targetBytes.length;
        if (sourceBytes == null) {
            beginIndex = 0;
            sourceBytes = new byte[targetSize];
        }
        if ((sourceSize = sourceBytes.length) - beginIndex < targetSize) {
            return sourceBytes;
        }
        System.arraycopy(targetBytes, 0, sourceBytes, beginIndex, targetSize);
        return sourceBytes;
    }

    public static byte[] intToBytesBig(int n) {
        byte[] src = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return src;
    }

    public static int bytesToInt(byte[] src, int offset) {
        return src[offset] & 0xFF | (src[offset + 1] & 0xFF) << 8 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 3] & 0xFF) << 24;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static float bytesToFloat(byte[] bytes) {
        if (bytes.length == 0) {
            return 0.0f;
        }
        ByteArrayInputStream mByteArrayInputStream = new ByteArrayInputStream(bytes);
        try (ByteArrayInputStream byteArrayInputStream = mByteArrayInputStream;){
            float f;
            try (DataInputStream mDataInputStream = new DataInputStream(mByteArrayInputStream);){
                f = mDataInputStream.readFloat();
            }
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static float bytesToFloat(byte[] bytes, int start) {
        float f;
        if (start < 0 || start > bytes.length - 4) {
            throw new IllegalArgumentException("Start index out of bounds");
        }
        byte[] floatBytes = Arrays.copyOfRange(bytes, start, start + 4);
        DataInputStream mDataInputStream = new DataInputStream(new ByteArrayInputStream(floatBytes));
        try {
            f = mDataInputStream.readFloat();
        }
        catch (Throwable throwable) {
            try {
                try {
                    mDataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        mDataInputStream.close();
        return f;
    }

    static {
        NF.setGroupingUsed(false);
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(4);
    }
}

