/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOTools {
    private static final Logger log = LoggerFactory.getLogger(IOTools.class);
    private static final String DEFAULT_PATH_PREFIX = "/";

    public static void getStream(String path, StreamRunnable runnable) {
        IOTools.getStream(path, runnable, notFindPath -> {});
    }

    public static void getStream(String path, StreamRunnable runnable, NotFindable notFindable) {
        String relativePath = IOTools.formatRelativePath(path);
        try (InputStream stream = IOTools.class.getResourceAsStream(relativePath);){
            if (stream != null) {
                runnable.run(stream);
            } else {
                notFindable.run(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatRelativePath(String path) {
        if (path == null) {
            throw new RuntimeException(new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u4f20\u5165\u7684\u53c2\u6570\u4e3a: null, \u8bf7\u68c0\u67e5\u53c2\u6570\u683c\u5f0f"}))));
        }
        if (!((String)path).startsWith(DEFAULT_PATH_PREFIX)) {
            path = DEFAULT_PATH_PREFIX + (String)path;
        }
        return path;
    }

    public static boolean hasResource(String path) {
        return IOTools.class.getResource(IOTools.formatRelativePath(path)) != null;
    }

    public static String readText(String path) {
        AtomicReference builder = new AtomicReference();
        IOTools.getStream(path, stream -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line).append("\r\n");
                }
                builder.set(sb.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, fileName -> {
            throw new RuntimeException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        });
        return (String)builder.get();
    }

    @FunctionalInterface
    public static interface NotFindable {
        public void run(String var1);
    }

    @FunctionalInterface
    public static interface StreamRunnable {
        public void run(InputStream var1);
    }
}

