/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.json.JSONArray;

public class SqlTools {
    private static final String PLACEHOLDER = "[ROW]";
    private static final String FORMAT_YEAR = "yyyy";
    private static final String FORMAT_MONTH = "yyyyMM";
    private static final String FORMAT_DAY = "yyyyMMdd";

    private static void validateArrayParam(Object arr) {
        if (arr == null) {
            throw new IllegalArgumentException("\u53c2\u6570 arr \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arr instanceof JSONArray && ((JSONArray)arr).isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570 arr \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arr instanceof List && ((List)arr).isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570 arr \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void validateSqlParam(String sql) {
        if (sql == null || sql.trim().isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570 sql \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void validateDateFormat(String format) {
        if (format == null || !format.equals(FORMAT_YEAR) && !format.equals(FORMAT_MONTH) && !format.equals(FORMAT_DAY)) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f: " + format + ", \u4ec5\u652f\u6301 yyyy/yyyyMM/yyyyMMdd");
        }
    }

    public static String renderUnionSql(JSONArray arr, String sql) {
        return SqlTools.renderUnionSql(arr, sql, (Boolean)true);
    }

    public static String renderUnionSql(JSONArray arr, String sql, Boolean wrapOuter) {
        return SqlTools.renderUnionSqlInternal(arr, sql, wrapOuter);
    }

    private static String renderUnionSqlInternal(JSONArray arr, String sql, Boolean wrapOuter) {
        SqlTools.validateArrayParam(arr);
        SqlTools.validateSqlParam(sql);
        if (!sql.contains(PLACEHOLDER)) {
            return sql;
        }
        StringBuilder result = new StringBuilder();
        if (wrapOuter.booleanValue()) {
            result.append("select * from (\n");
        }
        for (int i = 0; i < arr.length(); ++i) {
            Object value = arr.get(i);
            String subQuery = sql.replace(PLACEHOLDER, String.valueOf(value));
            result.append(subQuery);
            if (i >= arr.length() - 1) continue;
            result.append("\nunion all\n");
        }
        if (wrapOuter.booleanValue()) {
            result.append("\n) t");
        }
        return result.toString();
    }

    public static String renderUnionSql(List<?> arr, String sql) {
        return SqlTools.renderUnionSql(arr, sql, (Boolean)true);
    }

    public static String renderUnionSql(List<?> arr, String sql, Boolean wrapOuter) {
        SqlTools.validateArrayParam(arr);
        JSONArray jsonArray = new JSONArray(arr);
        return SqlTools.renderUnionSqlInternal(jsonArray, sql, wrapOuter);
    }

    public static String renderUnionSqlForDate(JSONArray arr, String sql, String format) {
        return SqlTools.renderUnionSqlForDate(arr, sql, format, (Boolean)true);
    }

    public static String renderUnionSqlForDate(JSONArray arr, String sql, String format, Boolean wrapOuter) {
        return SqlTools.renderUnionSqlForDateInternal(arr, sql, format, null, null, wrapOuter);
    }

    public static String renderUnionSqlForDate(JSONArray arr, String sql, String format, String minDate, String maxDate) {
        return SqlTools.renderUnionSqlForDateInternal(arr, sql, format, minDate, maxDate, true);
    }

    public static String renderUnionSqlForDate(JSONArray arr, String sql, String format, String minDate, String maxDate, Boolean wrapOuter) {
        return SqlTools.renderUnionSqlForDateInternal(arr, sql, format, minDate, maxDate, wrapOuter);
    }

    private static String renderUnionSqlForDateInternal(JSONArray arr, String sql, String format, String minDate, String maxDate, Boolean wrapOuter) {
        SqlTools.validateSqlParam(sql);
        if (!sql.contains(PLACEHOLDER)) {
            return sql;
        }
        SqlTools.validateDateFormat(format);
        if (maxDate == null || maxDate.trim().isEmpty()) {
            maxDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (arr == null || arr.isEmpty()) {
            arr = new JSONArray().put((Object)maxDate);
        }
        ArrayList<DateTime> dates = new ArrayList<DateTime>();
        for (int i = 0; i < arr.length(); ++i) {
            String dateStr = arr.getString(i);
            try {
                DateTime date = DateUtil.parse((CharSequence)dateStr);
                dates.add(date);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef: " + dateStr + ", \u652f\u6301\u683c\u5f0f yyyy-MM-dd \u6216 yyyy-MM-dd HH:mm:ss", e);
            }
        }
        Date arrMinDate = (Date)Collections.min(dates);
        Date arrMaxDate = (Date)Collections.max(dates);
        Date actualMinDate = arrMinDate;
        Date actualMaxDate = arrMaxDate;
        DateTime minBoundary = null;
        DateTime maxBoundary = null;
        if (minDate != null && !minDate.trim().isEmpty()) {
            try {
                minBoundary = DateUtil.parse((CharSequence)minDate);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u6700\u5c0f\u65e5\u671f\u683c\u5f0f\u9519\u8bef: " + minDate + ", \u652f\u6301\u683c\u5f0f yyyy-MM-dd", e);
            }
        }
        if (maxDate != null && !maxDate.trim().isEmpty()) {
            try {
                maxBoundary = DateUtil.parse((CharSequence)maxDate);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u6700\u5927\u65e5\u671f\u683c\u5f0f\u9519\u8bef: " + maxDate + ", \u652f\u6301\u683c\u5f0f yyyy-MM-dd", e);
            }
        }
        if (minBoundary != null && arrMinDate.before((Date)minBoundary)) {
            actualMinDate = minBoundary;
        }
        if (maxBoundary != null && arrMaxDate.after((Date)maxBoundary)) {
            actualMaxDate = maxBoundary;
        }
        if (actualMinDate.after(actualMaxDate)) {
            if (minBoundary != null && arrMaxDate.before((Date)minBoundary)) {
                actualMinDate = minBoundary;
                actualMaxDate = minBoundary;
            } else if (maxBoundary != null && arrMinDate.after((Date)maxBoundary)) {
                actualMinDate = maxBoundary;
                actualMaxDate = maxBoundary;
            }
        }
        LinkedHashSet<String> dateSequence = SqlTools.generateDateSequence(actualMinDate, actualMaxDate, format);
        StringBuilder result = new StringBuilder();
        if (wrapOuter.booleanValue()) {
            result.append("select * from (\n");
        }
        int index = 0;
        for (String formattedDate : dateSequence) {
            String subQuery = sql.replace(PLACEHOLDER, formattedDate);
            result.append(subQuery);
            if (index < dateSequence.size() - 1) {
                result.append("\nunion all\n");
            }
            ++index;
        }
        if (wrapOuter.booleanValue()) {
            result.append("\n) t");
        }
        return result.toString();
    }

    public static String renderUnionSqlForDate(List<String> arr, String sql, String format) {
        return SqlTools.renderUnionSqlForDate(arr, sql, format, (Boolean)true);
    }

    public static String renderUnionSqlForDate(List<String> arr, String sql, String format, Boolean wrapOuter) {
        JSONArray jsonArray = arr == null ? null : new JSONArray(arr);
        return SqlTools.renderUnionSqlForDateInternal(jsonArray, sql, format, null, null, wrapOuter);
    }

    public static String renderUnionSqlForDate(List<String> arr, String sql, String format, String minDate, String maxDate) {
        JSONArray jsonArray = arr == null ? null : new JSONArray(arr);
        return SqlTools.renderUnionSqlForDateInternal(jsonArray, sql, format, minDate, maxDate, true);
    }

    public static String renderUnionSqlForDate(List<String> arr, String sql, String format, String minDate, String maxDate, Boolean wrapOuter) {
        JSONArray jsonArray = arr == null ? null : new JSONArray(arr);
        return SqlTools.renderUnionSqlForDateInternal(jsonArray, sql, format, minDate, maxDate, wrapOuter);
    }

    private static LinkedHashSet<String> generateDateSequence(Date minDate, Date maxDate, String format) {
        LinkedHashSet<String> sequence = new LinkedHashSet<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String maxFormatted = sdf.format(maxDate);
        DateField incrementUnit = switch (format) {
            case FORMAT_YEAR -> DateField.YEAR;
            case FORMAT_MONTH -> DateField.MONTH;
            case FORMAT_DAY -> DateField.DAY_OF_MONTH;
            default -> throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f: " + format);
        };
        Date current = minDate;
        while (true) {
            String formatted = sdf.format(current);
            sequence.add(formatted);
            if (formatted.compareTo(maxFormatted) >= 0) break;
            current = DateUtil.offset((Date)current, (DateField)incrementUnit, (int)1);
        }
        return sequence;
    }
}

