/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.json;

import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.io.IOTools;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONParserConfiguration;

public class JsonTools {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj, Boolean modifyObj, JSONArray fields) {
        if (addObj == null) {
            throw new NullPointerException("\u8ffd\u52a0\u7684JSONObject\u4e0d\u5b58\u5728\uff01");
        }
        Set fieldSet = fields == null || fields.isEmpty() ? addObj.keySet() : fields.toList().stream().map(Object::toString).collect(Collectors.toSet());
        JSONObject targetObj = modifyObj != false ? obj : new JSONObject(obj.toMap());
        block5: for (String key : fieldSet) {
            Object item;
            Object object = item = addObj.opt(key);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JSONObject.class, JSONArray.class}, (Object)object, n)) {
                case -1: {
                    continue block5;
                }
                case 0: {
                    JSONObject json = (JSONObject)object;
                    JSONObject cloneItem = new JSONObject(json.toMap());
                    targetObj.put(key, (Object)cloneItem);
                    continue block5;
                }
                case 1: {
                    JSONArray array = (JSONArray)object;
                    JSONArray cloneItem = new JSONArray((Collection)array.toList());
                    targetObj.put(key, (Object)cloneItem);
                    continue block5;
                }
            }
            targetObj.put(key, item);
        }
        return targetObj;
    }

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj, Boolean modifyObj) {
        return JsonTools.addJSON(obj, addObj, modifyObj, null);
    }

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj, JSONArray fields) {
        return JsonTools.addJSON(obj, addObj, true, fields);
    }

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj) {
        return JsonTools.addJSON(obj, addObj, true);
    }

    public static JSONObject convertToJson(String str) {
        return JsonTools.convertToJson(str, false);
    }

    public static JSONObject convertToJson(String str, Boolean isOrdered) {
        if (str == null || str.isEmpty()) {
            return new JSONObject();
        }
        if (isOrdered.booleanValue()) {
            return new JSONObject(str, new JSONParserConfiguration().setOrdered(true));
        }
        return new JSONObject(str);
    }

    public static JSONObject convertToJson(JSONObject json) {
        return json;
    }

    public static JSONObject getOrderedJson() {
        return new JSONObject(new JSONParserConfiguration().setOrdered(true));
    }

    public static String jsonConvertToXml(JSONObject json, String rootName, boolean writeXmlDeclaration, String charset) {
        try {
            ObjectMapper jsonMapper = new ObjectMapper();
            XmlMapper xmlMapper = new XmlMapper();
            xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, false);
            xmlMapper.configure(ToXmlGenerator.Feature.UNWRAP_ROOT_OBJECT_NODE, true);
            JSONObject toXmlJson = new JSONObject();
            toXmlJson.put(rootName, (Object)json);
            JsonNode jsonNode = jsonMapper.readTree(toXmlJson.toString());
            String xmlBody = xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            if (writeXmlDeclaration) {
                return "<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n" + xmlBody;
            }
            return xmlBody;
        }
        catch (Exception e) {
            throw new RuntimeException("JSON \u8f6c\u6362\u4e3a XML \u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static String jsonConvertToXml(JSONObject json, String rootName, boolean writeXmlDeclaration) {
        return JsonTools.jsonConvertToXml(json, rootName, writeXmlDeclaration, "UTF-8");
    }

    public static String jsonConvertToXml(JSONObject json) {
        try {
            ObjectMapper jsonMapper = new ObjectMapper();
            XmlMapper xmlMapper = new XmlMapper();
            xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
            xmlMapper.configure(ToXmlGenerator.Feature.UNWRAP_ROOT_OBJECT_NODE, true);
            JSONObject toXmlJson = new JSONObject();
            toXmlJson.put("xml", (Object)json);
            JsonNode jsonNode = jsonMapper.readTree(toXmlJson.toString());
            return xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (Exception e) {
            throw new RuntimeException("JSON \u8f6c\u6362\u4e3a XML \u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static JSONObject xmlConvertToJson(String xmlStr, String charset) {
        try {
            XmlMapper xmlMapper = new XmlMapper();
            ObjectMapper jsonMapper = new ObjectMapper();
            JsonNode xmlNode = xmlMapper.readTree(xmlStr.getBytes(charset));
            return new JSONObject(jsonMapper.writeValueAsString((Object)xmlNode));
        }
        catch (IOException e) {
            throw new RuntimeException("XML \u8f6c\u6362\u4e3a JSON \u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static JSONObject xmlConvertToJson(String xmlStr) {
        String defaultCharset = Charset.defaultCharset().name();
        return JsonTools.xmlConvertToJson(xmlStr, defaultCharset);
    }

    public static JSONArray parseArray(String str) {
        return new JSONArray(str);
    }

    public static JSONArray parseArray(JSONArray json) {
        return json;
    }

    public static JSONArray getArray() {
        return new JSONArray();
    }

    public static JSONArray getArray(Object val) {
        int len = Integer.parseInt(val.toString());
        return new JSONArray((Object)new String[len]);
    }

    public static JSONObject getJson() {
        return new JSONObject();
    }

    public static JSONObject replaceJSON(JSONObject oldObj, JSONObject newObj) {
        for (String key : newObj.keySet()) {
            oldObj.put(key, newObj.get(key));
        }
        return oldObj;
    }

    public static JSONObject readJsonFile(String path) {
        return new JSONObject(IOTools.readText(path));
    }

    public static JSONObject readJsonFile(String path, Boolean isOrdered) {
        if (isOrdered.booleanValue()) {
            return new JSONObject(IOTools.readText(path), new JSONParserConfiguration().setOrdered(true));
        }
        return new JSONObject(IOTools.readText(path));
    }

    public static JSONArray readJsonArrayFile(String path) {
        return new JSONArray(IOTools.readText(path));
    }

    public static JSONObject formatJsonByParams(JSONObject object, JSONObject params) {
        if (!object.isEmpty()) {
            return new JSONObject(CommonTools.formatStrByParams(object.toString(), params));
        }
        return object;
    }

    public static JSONArray formatJsonArrayByParams(JSONArray array, JSONObject params) {
        if (!array.isEmpty()) {
            return new JSONArray(CommonTools.formatStrByParams(array.toString(), params));
        }
        return array;
    }

    public static <T> T toParse(JSONObject json, Class<T> obj) throws JsonProcessingException {
        return JsonTools.toParse(json.toString(), obj);
    }

    public static <T> T toParse(String json, Class<T> obj) throws JsonProcessingException {
        return (T)objectMapper.readValue(json, obj);
    }

    public static <T> List<T> toParseList(JSONArray json, Class<T> obj) throws JsonProcessingException {
        return (List)objectMapper.readValue(json.toString(), JsonTools.getCollectionType(List.class, obj));
    }

    public static JSONObject toJSON(Object entity) throws JsonProcessingException {
        return new JSONObject(objectMapper.writeValueAsString(entity));
    }

    public static <T> JSONArray toJsonArray(List<T> entity) throws JsonProcessingException {
        return new JSONArray(objectMapper.writeValueAsString(entity));
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> JSONObject objToJson(T obj) throws JsonProcessingException {
        return new JSONObject(objectMapper.writeValueAsString(obj));
    }

    public static JSONArray getKeys(JSONObject object) {
        return new JSONArray((Collection)object.keySet());
    }

    public static JSONArray packSettleJson(JSONObject json, String priceType) {
        JSONArray result = new JSONArray();
        if ("fixed".equals(priceType)) {
            JSONObject value = new JSONObject();
            value.put("f_unitprice", (Object)new BigDecimal(String.valueOf(json.get("f_unitprice"))));
            result.put((Object)value);
        } else if ("mixed".equals(priceType)) {
            JSONArray array = json.getJSONArray("detailprice");
            JSONObject obj = new JSONObject();
            obj.put("f_hybridprice1", (Object)new BigDecimal(String.valueOf(array.getJSONObject(0).get("f_price"))));
            obj.put("f_hybridprice2", (Object)new BigDecimal(String.valueOf(array.getJSONObject(1).get("f_price"))));
            obj.put("f_hybridprice1rate", (Object)new BigDecimal(String.valueOf(array.getJSONObject(0).get("f_ratio"))));
            result.put((Object)obj);
        } else if ("staired".equals(priceType)) {
            JSONArray array = json.getJSONArray("detailprice");
            for (Object object : array) {
                JSONObject obj = new JSONObject();
                obj.put("price", (Object)new BigDecimal(String.valueOf(((JSONObject)object).get("f_price"))));
                obj.put("amount", (Object)new BigDecimal(String.valueOf(((JSONObject)object).get("f_amount"))));
                result.put((Object)obj);
            }
            Iterator obj = new JSONObject();
            obj.put("sumamount", json.get("sumamount"));
            result.put((Object)obj);
        }
        return result;
    }

    public static boolean isContains(JSONObject obj, String key) {
        return obj.has(key);
    }

    public static JSONArray getJsonKeys(JSONObject obj) {
        return new JSONArray((Collection)obj.keySet());
    }

    public static boolean isNull(JSONObject obj, String key) {
        return obj.isNull(key);
    }

    public static boolean isNull(JSONObject obj) {
        return obj.isEmpty();
    }

    public static void validateField(JSONObject obj, Object fields) throws Exception {
        String errors = null;
        for (String string : fields instanceof JSONObject ? new JSONObject(fields.toString()).keySet().toArray() : ((String)fields).split(",")) {
            if (!"".equals(obj.get(string)) && obj.get(string) != null) continue;
            errors = String.valueOf(errors == null ? string : errors + String.valueOf(string)) + " ";
        }
        if (errors != null) {
            throw new Exception(errors + "\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        }
    }

    public static JSONObject remove(JSONObject colsToBeRemoved, JSONObject jo) {
        Set keySet1 = colsToBeRemoved.keySet();
        for (String s : keySet1) {
            jo.remove(s);
        }
        return jo;
    }

    public static JSONObject add(JSONObject obj, String addLabel, Object addVale) {
        obj.put(addLabel, addVale);
        return obj;
    }

    public static JSONObject removeKey(JSONObject obj, String key) {
        obj.remove(key);
        return obj;
    }

    public static Map<String, Object> toHashMap(JSONObject object) {
        return object.toMap();
    }

    public static JSONArray findDiff(JSONObject jo1, JSONObject jo2) {
        Set keySet1 = jo1.keySet();
        JSONArray jsonArray = new JSONArray();
        for (String s : keySet1) {
            if (!JsonTools.isValueEquals(jo1, jo2, s)) continue;
            JSONObject jo = new JSONObject();
            jo.put("field", (Object)s);
            jo.put("newVal", jo1.get(s) == null ? null : jo1.get(s).toString());
            jo.put("oldVal", jo2.get(s) == null ? null : jo2.get(s).toString());
            jsonArray.put((Object)jo);
        }
        return jsonArray;
    }

    public static boolean isValueEquals(JSONObject jo1, JSONObject jo2, String s) {
        if (jo1.isNull(s) && !jo2.isNull(s) || !jo1.isNull(s) && jo2.isNull(s)) {
            return false;
        }
        if (jo1.isNull(s) && (jo2.isNull(s) || "null".equals(jo2.get(s)))) {
            return false;
        }
        if (jo1.get(s) instanceof Integer) {
            if (jo2.get(s) instanceof BigDecimal) {
                return new BigDecimal((Integer)jo1.get(s)).compareTo((BigDecimal)jo2.get(s)) != 0;
            }
            try {
                return new BigDecimal((Integer)jo1.get(s)).compareTo(new BigDecimal(Integer.parseInt(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (jo1.get(s) instanceof String) {
            if (jo2.get(s) instanceof String) {
                return !jo1.get(s).equals(jo2.get(s));
            }
            try {
                return BigDecimal.valueOf(Double.parseDouble(jo1.get(s).toString())).compareTo((BigDecimal)jo2.get(s)) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (jo1.get(s) instanceof Double) {
            if (jo2.get(s) instanceof Integer) {
                return BigDecimal.valueOf((Double)jo1.get(s)).compareTo(new BigDecimal((Integer)jo2.get(s))) != 0;
            }
            try {
                return BigDecimal.valueOf((Double)jo1.get(s)).compareTo(BigDecimal.valueOf(Double.parseDouble(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return !jo2.get(s).equals(jo1.get(s));
    }

    @Deprecated
    public static JSONArray packJson(JSONObject json, String priceType) {
        return JsonTools.packSettleJson(json, priceType);
    }

    public static String toString(JSONArray array, String field) {
        StringBuilder result = new StringBuilder();
        for (Object object : array) {
            JSONObject obj = (JSONObject)object;
            String value = obj.optString(field);
            if (!"".contentEquals(result)) {
                result.append(",");
            }
            result.append("'").append(value).append("'");
        }
        return result.toString();
    }

    public static JSONArray page(JSONArray array, Integer pageSize) {
        JSONArray result = new JSONArray();
        int size = array.length();
        int pageCount = (int)Math.ceil((double)size / (double)pageSize.intValue());
        for (int i = 0; i < pageCount; ++i) {
            JSONArray page = new JSONArray();
            int end = Math.min((i + 1) * pageSize, size);
            for (int j = i * pageSize; j < end; ++j) {
                page.put(array.get(j));
            }
            result.put((Object)page);
        }
        return result;
    }

    public static JSONObject sortJSONObjectByDescendingKey(JSONObject json) {
        Map sortedMap = json.keySet().stream().sorted(String::compareTo).collect(Collectors.toMap(key -> key, arg_0 -> ((JSONObject)json).get(arg_0), (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return new JSONObject(sortedMap);
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

