/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.af.v4.system.common.plugins.core.ConvertTools;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecureTools {
    public static String AESEncrypt(String plainText, String key) {
        return SecureUtil.aes((byte[])ConvertTools.base64Decode(key.getBytes(StandardCharsets.UTF_8))).encryptBase64(plainText);
    }

    public static String AESDecrypt(String cipherText, String key) {
        return SecureUtil.aes((byte[])ConvertTools.base64Decode(key.getBytes(StandardCharsets.UTF_8))).decryptStr(cipherText);
    }

    public static String AESEncryptCBC(String data, String hexKey) {
        try {
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            SecretKeySpec secretKeySpec = new SecretKeySpec(HexUtil.decodeHex((String)hexKey), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] encryptedBytes = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
            String ivBase64 = Base64.getEncoder().encodeToString(iv);
            String encryptedBase64 = Base64.getEncoder().encodeToString(encryptedBytes);
            return "%s:%s".formatted(ivBase64, encryptedBase64);
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String AESDecryptCBC(String combinedText, String hexKey) {
        try {
            String[] parts = combinedText.split(":");
            String ivBase64 = parts[0];
            String encryptedBase64 = parts[1];
            byte[] iv = Base64.getDecoder().decode(ivBase64);
            byte[] encryptedBytes = Base64.getDecoder().decode(encryptedBase64);
            SecretKeySpec secretKeySpec = new SecretKeySpec(HexUtil.decodeHex((String)hexKey), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static Map<String, String> generateRSAKeyPair() {
        RSA rsa = SecureUtil.rsa();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("publicKey", rsa.getPublicKeyBase64());
        keyMap.put("privateKey", rsa.getPrivateKeyBase64());
        return keyMap;
    }

    public static String RSAEncrypt(String plainText, String publicKey) {
        try {
            RSA rsa = SecureUtil.rsa(null, (String)publicKey);
            return rsa.encryptBase64(plainText, StandardCharsets.UTF_8, KeyType.PublicKey);
        }
        catch (Exception e) {
            throw new RuntimeException("RSA\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String RSADecrypt(String cipherText, String privateKey) {
        try {
            RSA rsa = SecureUtil.rsa((String)privateKey, null);
            return rsa.decryptStr(cipherText, KeyType.PrivateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("RSA\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static String sign(String data, String privateKey) throws Exception {
        PrivateKey key = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initSign(key);
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(signature.sign());
    }

    public static boolean verify(String data, String sign, String publicKey) throws Exception {
        PublicKey key = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey)));
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initVerify(key);
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return signature.verify(Base64.getDecoder().decode(sign));
    }

    public static String AESEncryptCBCByIvLength(String data, String key, int ivLength) {
        try {
            byte[] keyBytes = SecureTools.parseKeyBytes(key);
            byte[] iv = SecureTools.generateIVFromKey(keyBytes, ivLength);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            SymmetricCrypto aes = new SymmetricCrypto("AES/CBC/PKCS5Padding", (SecretKey)secretKey, (AlgorithmParameterSpec)ivParameterSpec);
            return aes.encryptBase64(data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES-CBC\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String AESDecryptCBCByIvLength(String data, String key, int ivLength) {
        try {
            byte[] keyBytes = SecureTools.parseKeyBytes(key);
            byte[] iv = SecureTools.generateIVFromKey(keyBytes, ivLength);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            SymmetricCrypto aes = new SymmetricCrypto("AES/CBC/PKCS5Padding", (SecretKey)secretKey, (AlgorithmParameterSpec)ivParameterSpec);
            return aes.decryptStr(data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES-CBC\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    private static byte[] parseKeyBytes(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HexUtil.isHexNumber((String)key)) {
            return HexUtil.decodeHex((String)key);
        }
        return key.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] generateIVFromKey(byte[] keyBytes, int ivLength) {
        byte[] iv = Arrays.copyOfRange(keyBytes, 0, Math.min(ivLength, keyBytes.length));
        if (iv.length < 16) {
            byte[] paddedIv = new byte[16];
            System.arraycopy(iv, 0, paddedIv, 0, iv.length);
            iv = paddedIv;
        }
        return iv;
    }
}

