package com.af.v4.system.common.plugins.http.core.response;

import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

import static com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil.logExecutionTime;

/**
 * 标准异步响应实现
 *
 * @author Mr.river
 * @apiNote 自行根据成功和失败的响应处理
 */
public class StandardAsyncResponse implements FutureCallback<SimpleHttpResponse> {

    private static final Logger logger = LoggerFactory.getLogger(StandardAsyncResponse.class);

    private final StopWatch stopWatch;

    private final SuccessHandler successHandler;

    private final ErrorHandler errorHandler;

    public StandardAsyncResponse(SuccessHandler successHandler, ErrorHandler errorHandler) {
        this.successHandler = successHandler;
        this.errorHandler = errorHandler;
        stopWatch = new StopWatch();
        stopWatch.start();
    }

    public StandardAsyncResponse(SuccessHandler successHandler) {
        this.successHandler = successHandler;
        this.errorHandler = e -> logger.error("异步请求时发生异常：", e);
        stopWatch = new StopWatch();
        stopWatch.start();
    }


    @Override
    public void completed(SimpleHttpResponse response) {
        try {
            stopWatch.stop();
            logExecutionTime(stopWatch);
            String result = BaseHttpPoolUtil.getResponseData(response);
            successHandler.run(result);
        } catch (Exception e) {
            this.failed(e);
        }
    }

    @Override
    public void failed(Exception ex) {
        errorHandler.run(ex);
    }

    @Override
    public void cancelled() {

    }

    public interface SuccessHandler {
        void run(String response);
    }

    public interface ErrorHandler {
        void run(Exception e);
    }
}
