/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.wechat;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.wechat.WechatApi;
import com.af.v4.system.common.plugins.wechat.WechatAuthUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WechatApiUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(WechatApiUtils.class);
    private final WechatAuthUtils wechatAuthUtils;

    public WechatApiUtils(WechatAuthUtils wechatAuthUtils) {
        this.wechatAuthUtils = wechatAuthUtils;
    }

    private List<String> getAllOpenId(List<String> openIdArray, JSONObject authInfo, String nextOpenIds) {
        JSONObject result;
        String orgId = authInfo.getString("appid");
        String accessToken = (String)this.wechatAuthUtils.authorization(orgId, authInfo);
        String url = WechatApi.getGetOpenidUrl() + "?access_token=" + accessToken;
        if (nextOpenIds != null) {
            url = url + "&next_openid=" + nextOpenIds;
        }
        if ((result = new JSONObject(RestTools.get(url))).has("data")) {
            String nextOpenId = result.getString("next_openid");
            JSONObject data = result.getJSONObject("data");
            JSONArray openIds = data.getJSONArray("openid");
            for (Object openId : openIds) {
                openIdArray.add((String)openId);
            }
            if (nextOpenId.isEmpty()) {
                return openIdArray;
            }
            return this.getAllOpenId(openIdArray, authInfo, nextOpenId);
        }
        throw new ServiceException("\u83b7\u53d6\u6240\u6709\u7528\u6237\u7684OpenId\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + String.valueOf(result));
    }

    public List<String> getAllOpenId(JSONObject authInfo) {
        ArrayList<String> allOpenIds = new ArrayList<String>(10000);
        return this.getAllOpenId(allOpenIds, authInfo, null);
    }

    public JSONObject sendTemplateMessage(JSONObject authInfo, String openId, String templateId, String url, String miniprogram, JSONObject data) {
        JSONObject body = new JSONObject();
        body.put("touser", (Object)openId);
        body.put("template_id", (Object)templateId);
        body.put("url", (Object)url);
        body.put("miniprogram", (Object)miniprogram);
        body.put("data", (Object)data);
        String orgId = authInfo.getString("appid");
        String accessToken = (String)this.wechatAuthUtils.authorization(orgId, authInfo);
        String requestUrl = WechatApi.getSendTemplateMessageUrl() + "?access_token=" + accessToken;
        return new JSONObject(RestTools.post(requestUrl, body));
    }

    public JSONObject clearQuota(JSONObject authInfo) {
        String orgId = authInfo.getString("appid");
        JSONObject body = new JSONObject();
        body.put("appid", (Object)orgId);
        String accessToken = (String)this.wechatAuthUtils.authorization(orgId, authInfo);
        String requestUrl = WechatApi.getClearQuotaUrl() + "?access_token=" + accessToken;
        return new JSONObject(RestTools.post(requestUrl, body));
    }
}

