/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.calculate;

import com.af.v4.system.common.plugins.calculate.ISettlementInterface;
import com.af.v4.system.common.plugins.core.PriceFormatTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.json.JSONArray;
import org.json.JSONObject;

public class UnitpriceSettlement
implements ISettlementInterface {
    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        return this.calcChargeInternal(chargeInfo, gas, false);
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        return this.calcAmountInternal(chargeInfo, fee, false);
    }

    @Override
    public JSONObject calcCharge2(JSONArray chargeInfo, BigDecimal gas) {
        return this.calcChargeInternal(chargeInfo, gas, true);
    }

    @Override
    public JSONObject calcAmount2(JSONArray chargeInfo, BigDecimal fee) {
        return this.calcAmountInternal(chargeInfo, fee, true);
    }

    private JSONObject calcChargeInternal(JSONArray chargeInfo, BigDecimal gas, boolean useTwoDecimal) {
        BigDecimal unitprice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitprice")));
        BigDecimal chargenum = unitprice.multiply(gas);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", (Object)"\u56fa\u5b9a\u6c14\u4ef7");
        json.put("f_price", (Object)unitprice);
        json.put("f_gas", (Object)gas);
        json.put("f_money", (Object)chargenum);
        array.put((Object)json);
        JSONObject ret = new JSONObject();
        ret.put("chargeprice", (Object)array);
        ret.put("chargenum", (Object)chargenum);
        ret.put("gas", (Object)gas);
        ret.put("money", (Object)chargenum);
        if (useTwoDecimal) {
            PriceFormatTools.formatNumberTwoDecimal(ret, "f_price");
        } else {
            PriceFormatTools.formatNumber(ret, "f_price");
        }
        return ret;
    }

    private JSONObject calcAmountInternal(JSONArray chargeInfo, BigDecimal fee, boolean useTwoDecimal) {
        BigDecimal unitprice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitprice")));
        BigDecimal amount = fee.divide(unitprice, 4, RoundingMode.DOWN);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", (Object)"\u56fa\u5b9a\u6c14\u4ef7");
        json.put("f_price", (Object)unitprice);
        json.put("f_gas", (Object)amount);
        json.put("f_money", (Object)fee);
        array.put((Object)json);
        JSONObject ret = new JSONObject();
        ret.put("chargeprice", (Object)array);
        ret.put("gas", (Object)amount);
        ret.put("money", (Object)fee);
        ret.put("chargenum", (Object)fee);
        if (useTwoDecimal) {
            PriceFormatTools.formatNumberTwoDecimal(ret, "f_price");
        } else {
            PriceFormatTools.formatNumber(ret, "f_price");
        }
        return ret;
    }
}

