/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.af.v4.system.common.plugins.core.CalculateUtil;
import com.af.v4.system.common.plugins.core.NumberUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommonTools {
    public static Object getInstance(String className, JSONArray param) {
        Class<?> classInstance;
        try {
            classInstance = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (param != null && !param.isEmpty()) {
            Object[] objects = new Object[param.length()];
            Class[] paramClasses = new Class[param.length()];
            for (int i = 0; i < param.length(); ++i) {
                objects[i] = param.get(i);
                Class<?> clazz = objects[i].getClass();
                try {
                    Field f = clazz.getDeclaredField("TYPE");
                    paramClasses[i] = (Class)f.get(null);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    paramClasses[i] = clazz;
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Constructor<?> constructor = classInstance.getDeclaredConstructor(paramClasses);
                constructor.setAccessible(true);
                return constructor.newInstance(objects);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Constructor<?> constructor = classInstance.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInstance(String className) {
        return CommonTools.getInstance(className, null);
    }

    public static String getUUID(Boolean isSimple) {
        return UUID.fastUUID().toString(isSimple.booleanValue());
    }

    public static String getUUID() {
        return CommonTools.getUUID(false);
    }

    public static String md5(String param) {
        return MD5.create().digestHex(param);
    }

    public static String md5(String param, String salt) {
        return MD5.create().setSalt(salt.getBytes(StandardCharsets.UTF_8)).digestHex(param);
    }

    public static String MD5Sign(String text, String key, String charset, int length, boolean caseSensitive) {
        try {
            String signText = text + key;
            String md5Hex = DigestUtils.md5Hex((byte[])signText.getBytes(charset));
            if (length > 0 && length < 32) {
                md5Hex = md5Hex.substring(0, length);
            }
            return caseSensitive ? md5Hex.toUpperCase() : md5Hex.toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u52a0\u7b7e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", e);
        }
    }

    public static boolean MD5Verify(String content, String key, String charset, int length, boolean upperCase, String sign) {
        String calculatedSign = CommonTools.MD5Sign(content, key, charset, length, upperCase);
        return calculatedSign.equals(sign);
    }

    public static int getRandomNumber(Integer min, Integer max) {
        return RandomUtil.randomInt((int)min, (int)(max + 1));
    }

    public static boolean isNumeric(String str) {
        return NumberUtil.isNumeric(str);
    }

    public static BigDecimal add(Object o1, Object o2) {
        return CalculateUtil.add(o1, o2);
    }

    public static BigDecimal add(Object o1, Object o2, Integer scale) {
        return CalculateUtil.add(o1, o2, scale);
    }

    public static BigDecimal sub(Object o1, Object o2) {
        return CalculateUtil.sub(o1, o2);
    }

    public static BigDecimal sub(Object o1, Object o2, Integer scale) {
        return CalculateUtil.sub(o1, o2, scale);
    }

    public static BigDecimal mul(Object o1, Object o2) {
        return CalculateUtil.mul(o1, o2);
    }

    public static BigDecimal mul(Object o1, Object o2, Integer scale) {
        return CalculateUtil.mul(o1, o2, scale);
    }

    public static BigDecimal div(Object o1, Object o2) {
        return CalculateUtil.div(o1, o2);
    }

    public static BigDecimal div(Object o1, Object o2, Integer scale) {
        return CalculateUtil.div(o1, o2, scale);
    }

    public static BigDecimal divUp(Object o1, Object o2, Integer scale) {
        return CalculateUtil.div(o1, o2, (int)scale, RoundingMode.UP);
    }

    public static JSONArray split(String str, String separator) {
        return new JSONArray((Collection)StrUtil.split((CharSequence)str, (CharSequence)separator));
    }

    public static JSONObject url2json(String urlParams) {
        String[] split;
        JSONObject result = new JSONObject();
        for (String entry : split = urlParams.split("&")) {
            String[] mapEntry = entry.split("=");
            String value = mapEntry.length > 1 ? mapEntry[1] : "";
            result.put(mapEntry[0], (Object)value);
        }
        return result;
    }

    public static boolean isContains(String str, String searchStr) {
        return StrUtil.contains((CharSequence)str, (CharSequence)searchStr);
    }

    public static String union(JSONArray array) {
        StringBuilder result = new StringBuilder();
        array.forEach(item -> result.append("'").append(item).append("',"));
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String union(JSONArray array, String column) {
        StringBuilder result = new StringBuilder();
        array.forEach(item -> {
            if (((JSONObject)item).has(column)) {
                result.append("'").append(((JSONObject)item).get(column)).append("',");
            }
        });
        if (!result.isEmpty()) {
            result.deleteCharAt(result.length() - 1);
            return result.toString();
        }
        return null;
    }

    public static String union(ArrayList<?> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Object item : list) {
            result.append("'").append(item).append("',");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String formatStrByParams(String str, JSONObject params) {
        Set keys = params.keySet();
        for (String key : keys) {
            str = str.replace("{" + key + "}", params.get(key).toString());
        }
        return str;
    }
}

