/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core;

import com.af.v4.system.common.plugins.http.config.CloseHttpLogHandler;
import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public abstract class BaseHttpPoolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseHttpPoolUtil.class);
    private static final Long FINAL_SLOW_TIME_VALUE = 2000L;

    protected static void setRequestConfig(HttpClientConfig config, HttpUriRequestBase httpRequestBase) {
        if (config == null) {
            config = new HttpClientConfig.Builder().build();
        }
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)config.getSocketTimeout().intValue())).build();
        httpRequestBase.setConfig(requestConfig);
    }

    protected static void setHeaders(HttpRequest base, String headersStr) {
        if (headersStr != null && !headersStr.isEmpty()) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = String.valueOf(headers.get(key));
                base.setHeader(key, (Object)val);
            }
        }
    }

    protected static List<NameValuePair> paramsConverter(JSONObject params) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        Set paramsSet = params.keySet();
        for (String key : paramsSet) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(key, String.valueOf(params.get(key))));
        }
        return nameValuePairs;
    }

    protected static void setBody(HttpRequest base, String body) {
        if (body != null && !body.isEmpty()) {
            if (base instanceof SimpleHttpRequest) {
                SimpleHttpRequest request = (SimpleHttpRequest)base;
                request.setBody(body, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
            } else if (base instanceof BasicClassicHttpRequest) {
                BasicClassicHttpRequest request = (BasicClassicHttpRequest)base;
                StringEntity se = new StringEntity(body, StandardCharsets.UTF_8);
                request.setEntity((HttpEntity)se);
            }
        }
    }

    protected static void setUrlEncodedBody(ClassicHttpRequest base, String body) {
        if (!body.isEmpty()) {
            base.setEntity((HttpEntity)new UrlEncodedFormEntity(BaseHttpPoolUtil.paramsConverter(new JSONObject(body)), StandardCharsets.UTF_8));
        }
    }

    public static String getResponseData(HttpResponse response) throws IOException, ParseException {
        String result = null;
        String code = String.valueOf(response.getCode());
        if (response instanceof ClassicHttpResponse) {
            ClassicHttpResponse classicHttpResponse = (ClassicHttpResponse)response;
            HttpEntity entity = classicHttpResponse.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
        } else if (response instanceof SimpleHttpResponse) {
            SimpleHttpResponse simpleHttpResponse = (SimpleHttpResponse)response;
            result = new String(simpleHttpResponse.getBodyBytes(), StandardCharsets.UTF_8);
        }
        if (!code.startsWith(String.valueOf(200).substring(0, 1))) {
            String reasonPhrase = response.getReasonPhrase();
            JSONObject errorResult = new JSONObject();
            errorResult.put("code", (Object)code).put("data", (Object)result).put("msg", (Object)reasonPhrase);
            result = errorResult.toString();
        }
        return result;
    }

    public static void logExecutionTime(StopWatch stopWatch) {
        boolean disableLogPrint = CloseHttpLogHandler.getDisableLogPrintValue();
        if (!disableLogPrint) {
            long time = stopWatch.getTotalTimeMillis();
            String text = "\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + time + "ms";
            if (time >= FINAL_SLOW_TIME_VALUE) {
                LOGGER.warn(text);
            } else {
                LOGGER.info(text);
            }
        }
    }

    public static JSONObject buildHeader(String headers) {
        JSONObject headerJson = headers == null || headers.isEmpty() ? new JSONObject() : new JSONObject(headers);
        if (!headerJson.has("Content-Type")) {
            headerJson.put("Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());
        }
        return headerJson;
    }
}

