/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.af.v4.system.common.plugins.core.ConvertTools;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecureTools {
    public static String AESEncrypt(String plainText, String key) {
        return SecureUtil.aes((byte[])ConvertTools.base64Decode(key.getBytes(StandardCharsets.UTF_8))).encryptBase64(plainText);
    }

    public static String AESDecrypt(String cipherText, String key) {
        return SecureUtil.aes((byte[])ConvertTools.base64Decode(key.getBytes(StandardCharsets.UTF_8))).decryptStr(cipherText);
    }

    public static String AESDecryptCBC(String combinedText, String hexKey) {
        try {
            String[] parts = combinedText.split(":");
            String ivBase64 = parts[0];
            String encryptedBase64 = parts[1];
            byte[] iv = Base64.getDecoder().decode(ivBase64);
            byte[] encryptedBytes = Base64.getDecoder().decode(encryptedBase64);
            SecretKeySpec secretKeySpec = new SecretKeySpec(SecureTools.hexStringToByteArray(hexKey), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static Map<String, String> generateRSAKeyPair() {
        RSA rsa = SecureUtil.rsa();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("publicKey", rsa.getPublicKeyBase64());
        keyMap.put("privateKey", rsa.getPrivateKeyBase64());
        return keyMap;
    }

    public static String RSAEncrypt(String plainText, String publicKey) {
        try {
            RSA rsa = SecureUtil.rsa(null, (String)publicKey);
            return rsa.encryptBase64(plainText, StandardCharsets.UTF_8, KeyType.PublicKey);
        }
        catch (Exception e) {
            throw new RuntimeException("RSA\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String RSADecrypt(String cipherText, String privateKey) {
        try {
            RSA rsa = SecureUtil.rsa((String)privateKey, null);
            return rsa.decryptStr(cipherText, KeyType.PrivateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("RSA\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static String sign(String data, String privateKey) throws Exception {
        PrivateKey key = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initSign(key);
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(signature.sign());
    }

    public static boolean verify(String data, String sign, String publicKey) throws Exception {
        PublicKey key = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey)));
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initVerify(key);
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return signature.verify(Base64.getDecoder().decode(sign));
    }
}

