/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.concurrent;

import com.af.v4.system.common.plugins.concurrent.BatchTaskProcessor;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicBatchTaskProcessor
extends BatchTaskProcessor<JSONObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicBatchTaskProcessor.class);

    public JSONObject process(JSONArray items, String taskType, Consumer<JSONObject> taskHandler, Function<JSONObject, Object> preProcessor, Consumer<JSONObject> successCallback, Consumer<JSONObject> failureCallback) {
        JSONArray processedItems;
        BatchTaskProcessor.TaskType taskTypeEnum = BatchTaskProcessor.TaskType.toType(taskType);
        int chunkSize = this.calculateChunkSize(items.length(), taskTypeEnum);
        if (preProcessor != null) {
            JSONObject params = new JSONObject();
            params.put("items", (Object)items);
            processedItems = (JSONArray)preProcessor.apply(params);
        } else {
            processedItems = items;
        }
        JSONArray chunks = this.splitList(processedItems, chunkSize);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        JSONObject result = new JSONObject();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger failureCount = new AtomicInteger(0);
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            for (Object obj : chunks) {
                JSONArray chunk = (JSONArray)obj;
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    for (Object chunkObj : chunk) {
                        JSONObject item = (JSONObject)chunkObj;
                        try {
                            taskHandler.accept(item);
                            successCount.incrementAndGet();
                            if (successCallback == null) continue;
                            successCallback.accept(item);
                        }
                        catch (Exception e) {
                            failureCount.incrementAndGet();
                            if (failureCallback != null) {
                                failureCallback.accept(item);
                            }
                            LOGGER.error("Error processing task: {}", (Object)item, (Object)e);
                        }
                    }
                }, executor);
                futures.add(future);
            }
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        result.put("totalItems", processedItems.length());
        result.put("chunkSize", chunkSize);
        result.put("totalChunks", chunks.length());
        result.put("successCount", successCount.get());
        result.put("failureCount", failureCount.get());
        LOGGER.info("Batch task processing completed: {}", (Object)result);
        return result;
    }

    protected JSONArray splitList(JSONArray list, int chunkSize) {
        JSONArray chunks = new JSONArray();
        int length = list.length();
        for (int i = 0; i < length; i += chunkSize) {
            int end = Math.min(i + chunkSize, length);
            chunks.put((Object)list.subList(i, end));
        }
        return chunks;
    }
}

