/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import com.af.v4.system.common.plugins.core.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalculateUtil {
    private static final Logger log = LoggerFactory.getLogger(CalculateUtil.class);

    public static BigDecimal add(Object addOne, Object addAnother) {
        return CalculateUtil.add(addOne, addAnother, 4);
    }

    public static BigDecimal add(Object addOne, Object addAnother, Integer scaleNum) {
        return CalculateUtil.add(NumberUtil.getBigDecimal(addOne), NumberUtil.getBigDecimal(addAnother), scaleNum, RoundingMode.DOWN);
    }

    public static BigDecimal add(BigDecimal addOne, BigDecimal addAnother) {
        return CalculateUtil.add(addOne, addAnother, 4, RoundingMode.DOWN);
    }

    public static BigDecimal add(BigDecimal addOne, BigDecimal addAnother, int scaleNum, RoundingMode mode) {
        return NumberUtil.commonParse(addOne.add(addAnother), scaleNum, mode);
    }

    public static BigDecimal sub(Object minuend, Object subtrahend) {
        return CalculateUtil.sub(minuend, subtrahend, 4);
    }

    public static BigDecimal sub(Object minuend, Object subtrahend, Integer scaleNum) {
        return CalculateUtil.sub(NumberUtil.getBigDecimal(minuend), NumberUtil.getBigDecimal(subtrahend), scaleNum, RoundingMode.DOWN);
    }

    public static BigDecimal sub(BigDecimal minuend, BigDecimal subtrahend) {
        return CalculateUtil.sub(minuend, subtrahend, 4, RoundingMode.DOWN);
    }

    public static BigDecimal sub(BigDecimal minuend, BigDecimal subtrahend, int scaleNum, RoundingMode mode) {
        return NumberUtil.commonParse(minuend.subtract(subtrahend), scaleNum, mode);
    }

    public static BigDecimal mul(Object multiplierOne, Object multiplierAnother) {
        return CalculateUtil.mul(multiplierOne, multiplierAnother, 4);
    }

    public static BigDecimal mul(Object multiplierOne, Object multiplierAnother, Integer scaleNum) {
        return CalculateUtil.mul(NumberUtil.getBigDecimal(multiplierOne), NumberUtil.getBigDecimal(multiplierAnother), scaleNum, RoundingMode.DOWN);
    }

    public static BigDecimal mul(BigDecimal multiplierOne, BigDecimal multiplierAnother) {
        return CalculateUtil.mul(multiplierOne, multiplierAnother, 4, RoundingMode.DOWN);
    }

    public static BigDecimal mul(BigDecimal multiplierOne, BigDecimal multiplierAnother, int scaleNum, RoundingMode mode) {
        return NumberUtil.commonParse(multiplierOne.multiply(multiplierAnother), scaleNum, mode);
    }

    public static BigDecimal div(Object dividend, Object divisor) {
        return CalculateUtil.div(dividend, divisor, 4);
    }

    public static BigDecimal div(Object dividend, Object divisor, Integer scaleNum) {
        return CalculateUtil.div(NumberUtil.getBigDecimal(dividend), NumberUtil.getBigDecimal(divisor), scaleNum, RoundingMode.DOWN);
    }

    public static BigDecimal div(BigDecimal dividend, BigDecimal divisor) {
        return CalculateUtil.div(dividend, divisor, 4, RoundingMode.DOWN);
    }

    public static BigDecimal div(BigDecimal dividend, BigDecimal divisor, int scaleNum, RoundingMode mode) {
        return dividend.divide(divisor, scaleNum, mode);
    }
}

