package com.af.v4.system.common.plugins.wechat;

/**
 * 微信开放接口Api
 *
 * @see <a href="https://developers.weixin.qq.com/doc/offiaccount/Getting_Started/Overview.html">微信公众平台开发概述</a>
 */
public class WechatApi {
    // 基础地址
    private static final String BASE_URL = "https://api.weixin.qq.com/cgi-bin";
    /**
     * 鉴权接口
     *
     * @see <a href="https://developers.weixin.qq.com/doc/offiaccount/Basic_Information/getStableAccessToken.html">获取 Stable Access token</a>
     */
    private static final String AUTH_URL = "/stable_token";
    /**
     * 获取OpenId接口
     *
     * @see <a href="https://developers.weixin.qq.com/doc/offiaccount/User_Management/Getting_a_User_List.html">获取用户列表</a>
     */
    private static final String GET_OPENID_URL = "/user/get";
    /**
     * 发送模板消息接口
     *
     * @see <a href="https://developers.weixin.qq.com/doc/offiaccount/Message_Management/Template_Message_Interface.html#发送模板消息">发送模板消息</a>
     */
    private static final String SEND_TEMPLATE_MESSAGE_URL = "/message/template/send";
    /**
     * 清空api的调用quota接口
     *
     * @see <a href="https://developers.weixin.qq.com/doc/offiaccount/openApi/clear_quota.html">清空api的调用quota</a>
     */
    private static final String CLEAR_QUOTA_URL = "/clear_quota";

    public static String getAuthUrl() {
        return getBaseUrl() + AUTH_URL;
    }

    public static String getGetOpenidUrl() {
        return getBaseUrl() + GET_OPENID_URL;
    }

    public static String getSendTemplateMessageUrl() {
        return getBaseUrl() + SEND_TEMPLATE_MESSAGE_URL;
    }

    public static String getClearQuotaUrl() {
        return getBaseUrl() + CLEAR_QUOTA_URL;
    }

    private static String getBaseUrl() {
        return BASE_URL;
    }
}
